<?php
// Telegram bot with command-based interface and complete admin features

// ✅ DEBUG MODE - TURN ON FOR ERRORS
error_reporting(E_ALL);
ini_set('display_errors', 1);

$botToken = '8599601595:AAH068O21M7smave7jX9Kop1Gpfn4VVaMN0';

// DEBUG MODE - Set to true for error logging
$DEBUG_MODE = true;

// Log input for debugging
$input = file_get_contents('php://input');
if ($DEBUG_MODE && !empty($input)) {
    file_put_contents('debug.log', date('Y-m-d H:i:s') . " - Input: " . $input . "\n", FILE_APPEND);
}

// CHANNEL VERIFICATION SETTINGS - ALL THREE CHANNELS ARE NOW COMPULSORY
$REQUIRED_CHANNELS = [
    [
        'title' => 'OSINT BY SALAAR',
        'chat_id' => '-1003550297528',
        'compulsory' => true,
        'link' => 'https://t.me/+iIQJ_ERNvz45OWU1'
    ],
    [
        'title' => 'ZENTRIX OSINT',
        'chat_id' => '-1003376910382',
        'compulsory' => true,
        'link' => 'https://t.me/+Hys-s_g3kNw4NzA1'
    ]
    
];

$WELCOME_TEXT  = "╔═══════════════════════════════════════════╗
║          🤖 OSINT INFORMATION BOT            ║
╠═══════════════════════════════════════════╣
║    Developer: SALAAR          ║
╚═══════════════════════════════════════════╝";
$BACKEND_BASE  = 'https://api.paanel.shop/numapi.php?action=api&key=SALAAR&number=';
$VEHICLE_API   = 'https://api.paanel.shop/numapi.php?action=api&key=SALAAR&vehicle=';
// AADHAR API CHANGED
$AADHAR_API    = 'https://api.paanel.shop/numapi.php?action=api&key=SALAAR&aadhar=';
// AADHAR FAMILY API ADDED
$AADHAR_FAMILY_API = 'https://api.paanel.shop/numapi.php?action=api&key=SALAAR&aadhar_family=';
// FAMPAY API ADDED
$FAMPAY_API = 'https://api.paanel.shop/numapi.php?action=api&key=SALAAR&test3=';
// PAKISTAN API CHANGED
$PAKISTAN_NUMBER_API = 'https://mynk-pakapi.vercel.app/api/lookup?query=';
$INSTAGRAM_API = 'https://newinstainfoapi.anshppt19.workers.dev/info?username=';
$IP_INFO_API   ='http://ip-api.com/json/';
$TELEGRAM_ID_API = 'https://salaar-tg.vercel.app/user-details?user=';

// Group link and info
$GROUP_LINK = "https://t.me/+H4qK3AnhiE1hMWJl";
$GROUP_USERNAME = "@osint_group"; // Fixed invalid link

// Bot invite link
$BOT_INVITE_LINK = "https://t.me/OSINTBYASHU_bott?startgroup=true";

// Minimum group members required
$MIN_GROUP_MEMBERS = 20;

// Allowed groups (empty array means all groups are allowed)
$ALLOWED_GROUPS = [];

// Admin user IDs (replace with actual admin IDs)
$ADMINS = [
    8294966019 // Replace with your Telegram ID
];

// Blocked numbers with special responses
$BLOCKED_NUMBERS = [
    '93050601032' => "🚫 Access Denied\n❌ This number is protected\n⚠️ Please try another number",
    '8935008209' => "🚫 Access Denied\n❌ This number is protected\n⚠️ Please try another number",
];

// Maximum message length for Telegram (with some buffer) - CHANGED FROM 4000 TO 3900
$MAX_MESSAGE_LENGTH = 3900; // 4096 se 196 characters ka buffer 

// File to store ALL chat IDs (users + groups)
$CHAT_STORAGE_FILE = 'all_chats.json';
$BROADCAST_STATE_FILE = 'broadcast_state.json';

// User search limits storage - CHANGED FROM 10 TO 5
$USER_LIMITS_FILE = 'user_limits.json';

// Admin states storage
$ADMIN_STATES_FILE = 'admin_states.json';

// User input states storage (to track which button was pressed)
$USER_INPUT_STATES_FILE = 'user_input_states.json';

// Group settings storage
$GROUP_SETTINGS_FILE = 'group_settings.json';

// FAMPAY SEARCH TIMERS storage
$FAMPAY_TIMERS_FILE = 'fampay_timers.json';

// ---------- DEBUG FUNCTIONS ----------
function debugLog($message, $data = null) {
    global $DEBUG_MODE;
    if (!$DEBUG_MODE) return;
    
    $logMessage = date('Y-m-d H:i:s') . " - " . $message;
    if ($data !== null) {
        $logMessage .= " - " . json_encode($data);
    }
    $logMessage .= "\n";
    
    file_put_contents('debug.log', $logMessage, FILE_APPEND);
}

// ---------- File Initialization ----------
function initializeFiles() {
    global $CHAT_STORAGE_FILE, $USER_LIMITS_FILE, $BROADCAST_STATE_FILE, $ADMIN_STATES_FILE, $USER_INPUT_STATES_FILE, $GROUP_SETTINGS_FILE, $FAMPAY_TIMERS_FILE;
    
    $files = [
        $CHAT_STORAGE_FILE => [],
        $USER_LIMITS_FILE => [],
        $BROADCAST_STATE_FILE => [],
        $ADMIN_STATES_FILE => [],
        $USER_INPUT_STATES_FILE => [],
        $GROUP_SETTINGS_FILE => [],
        $FAMPAY_TIMERS_FILE => []
    ];
    
    foreach ($files as $file => $defaultContent) {
        if (!file_exists($file)) {
            file_put_contents($file, json_encode($defaultContent, JSON_PRETTY_PRINT));
        }
        // Ensure file is writable
        if (file_exists($file)) {
            chmod($file, 0666);
        }
    }
}

// Initialize files when script starts
initializeFiles();

// ---------- FAMPAY TIMER FUNCTIONS ----------

// Load fampay timers from file
function loadFampayTimers() {
    global $FAMPAY_TIMERS_FILE;
    if (file_exists($FAMPAY_TIMERS_FILE)) {
        return json_decode(file_get_contents($FAMPAY_TIMERS_FILE), true) ?: [];
    }
    return [];
}

// Save fampay timers to file
function saveFampayTimers($timers) {
    global $FAMPAY_TIMERS_FILE;
    file_put_contents($FAMPAY_TIMERS_FILE, json_encode($timers, JSON_PRETTY_PRINT));
}

// Check if user can search fampay (10 minute cooldown)
function canSearchFampay($userId) {
    // Admin users can always search
    if (isAdmin($userId)) {
        return true;
    }
    
    $timers = loadFampayTimers();
    $currentTime = time();
    
    if (!isset($timers[$userId])) {
        return true;
    }
    
    $lastSearchTime = $timers[$userId];
    $cooldownPeriod = 600; // 10 minutes in seconds
    
    if (($currentTime - $lastSearchTime) >= $cooldownPeriod) {
        return true;
    }
    
    return false;
}

// Update fampay search timer for user
function updateFampayTimer($userId) {
    $timers = loadFampayTimers();
    $timers[$userId] = time();
    saveFampayTimers($timers);
}

// Get remaining cooldown time for fampay
function getFampayCooldown($userId) {
    $timers = loadFampayTimers();
    $currentTime = time();
    
    if (!isset($timers[$userId])) {
        return 0;
    }
    
    $lastSearchTime = $timers[$userId];
    $cooldownPeriod = 600; // 10 minutes in seconds
    $remaining = $cooldownPeriod - ($currentTime - $lastSearchTime);
    
    return max(0, $remaining);
}

// ---------- CHANNEL VERIFICATION FUNCTIONS ----------

// Check if user is member of a channel
function isUserInChannel($userId, $chatId) {
    try {
        $result = tg('getChatMember', [
            'chat_id' => $chatId,
            'user_id' => $userId
        ]);
        
        if (!$result['ok']) {
            return false;
        }
        
        $status = $result['result']['status'] ?? 'left';
        
        // Return true if member, admin, or creator
        return in_array($status, ['member', 'administrator', 'creator']);
        
    } catch (Exception $e) {
        return false;
    }
}

// Check if user has verified (joined required channels)
function isUserVerified($userId) {
    global $REQUIRED_CHANNELS, $ADMINS;
    
    // Admins are always verified
    if (in_array($userId, $ADMINS)) {
        return true;
    }
    
    // Check ALL compulsory channels
    foreach ($REQUIRED_CHANNELS as $channel) {
        if ($channel['compulsory']) {
            if (!isUserInChannel($userId, $channel['chat_id'])) {
                return false;
            }
        }
    }
    
    return true;
}

// Get channel verification message with professional design
function getVerificationMessage($userId = null) {
    global $REQUIRED_CHANNELS;
    
    $message = "🔐 CHANNEL VERIFICATION REQUIRED\n";
    $message .= "═══════════════════════════════\n\n";
    $message .= "To use this bot, you must join ALL THREE channels:\n\n";
    
    foreach ($REQUIRED_CHANNELS as $index => $channel) {
        $channelNum = $index + 1;
        $message .= "📢 CHANNEL {$channelNum}\n";
        $message .= "   └─ {$channel['title']}\n";
        $message .= "   └─ {$channel['link']}\n\n";
    }
    
    $message .= "📋 Steps:\n";
    $message .= "1. Join ALL THREE channels above\n";
    $message .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
    $message .= "3. Start using the bot\n\n";
    $message .= "⚠️ Note: All three channels are compulsory";
    
    return $message;
}

// ---------- helpers ----------
function tg($method, $params) {
    global $botToken;
    $url = "https://api.telegram.org/bot{$botToken}/{$method}";
    $ch  = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => $params,
        CURLOPT_TIMEOUT        => 30,
        CURLOPT_CONNECTTIMEOUT => 10
    ]);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function html_pre($t) {
    return '<pre>'.htmlspecialchars($t, ENT_QUOTES|ENT_SUBSTITUTE, 'UTF-8').'</pre>';
}

// Check if user is admin
function isAdmin($userId) {
    global $ADMINS;
    return in_array($userId, $ADMINS);
}

// Load group settings
function loadGroupSettings() {
    global $GROUP_SETTINGS_FILE;
    if (file_exists($GROUP_SETTINGS_FILE)) {
        return json_decode(file_get_contents($GROUP_SETTINGS_FILE), true) ?: [];
    }
    return [];
}

// Save group settings
function saveGroupSettings($settings) {
    global $GROUP_SETTINGS_FILE;
    file_put_contents($GROUP_SETTINGS_FILE, json_encode($settings, JSON_PRETTY_PRINT));
}

// Check if group is allowed
function isGroupAllowed($chatId) {
    global $ALLOWED_GROUPS, $MIN_GROUP_MEMBERS;
    
    // If allowed groups list is empty, all groups are allowed (with member check)
    if (empty($ALLOWED_GROUPS)) {
        return hasMinimumMembers($chatId);
    }
    
    // If group is in allowed list, check member count
    if (in_array($chatId, $ALLOWED_GROUPS)) {
        return hasMinimumMembers($chatId);
    }
    
    return false;
}

// Add group to allowed list
function addGroupToAllowed($chatId, $groupName = '') {
    global $ALLOWED_GROUPS;
    $settings = loadGroupSettings();
    
    if (!in_array($chatId, $ALLOWED_GROUPS)) {
        $ALLOWED_GROUPS[] = $chatId;
    }
    
    $settings['allowed_groups'][$chatId] = [
        'name' => $groupName,
        'added_at' => time(),
        'member_count' => getGroupMemberCount($chatId)
    ];
    
    saveGroupSettings($settings);
    return true;
}

// Remove group from allowed list
function removeGroupFromAllowed($chatId) {
    global $ALLOWED_GROUPS;
    $settings = loadGroupSettings();
    
    $ALLOWED_GROUPS = array_diff($ALLOWED_GROUPS, [$chatId]);
    
    if (isset($settings['allowed_groups'][$chatId])) {
        unset($settings['allowed_groups'][$chatId]);
        saveGroupSettings($settings);
    }
    
    return true;
}

// Get group member count
function getGroupMemberCount($chatId) {
    $result = tg('getChatMemberCount', ['chat_id' => $chatId]);
    if ($result['ok']) {
        return $result['result'];
    }
    return 0;
}

// Store ALL chat IDs (users + groups)
function storeChatId($chatId, $chatType = 'private', $userId = null) {
    global $CHAT_STORAGE_FILE;
    
    $chats = [];
    if (file_exists($CHAT_STORAGE_FILE)) {
        $chats = json_decode(file_get_contents($CHAT_STORAGE_FILE), true) ?: [];
    }
    
    $chatInfo = [
        'chat_id' => $chatId,
        'type' => $chatType,
        'user_id' => $userId,
        'timestamp' => time()
    ];
    
    // Only store if not already stored
    $found = false;
    foreach ($chats as $chat) {
        if ($chat['chat_id'] == $chatId) {
            $found = true;
            break;
        }
    }
    
    if (!$found) {
        $chats[] = $chatInfo;
        file_put_contents($CHAT_STORAGE_FILE, json_encode($chats, JSON_PRETTY_PRINT));
    }
}

// Get all chat IDs for broadcast (users + groups)
function getAllChatIds() {
    global $CHAT_STORAGE_FILE;
    
    if (file_exists($CHAT_STORAGE_FILE)) {
        $chats = json_decode(file_get_contents($CHAT_STORAGE_FILE), true) ?: [];
        $chatIds = [];
        foreach ($chats as $chat) {
            $chatIds[] = $chat['chat_id'];
        }
        return $chatIds;
    }
    
    return [];
}

// Get chat statistics
function getChatStats() {
    global $CHAT_STORAGE_FILE;
    
    if (!file_exists($CHAT_STORAGE_FILE)) {
        return ['total' => 0, 'users' => 0, 'groups' => 0];
    }
    
    $chats = json_decode(file_get_contents($CHAT_STORAGE_FILE), true) ?: [];
    $stats = ['total' => count($chats), 'users' => 0, 'groups' => 0];
    
    foreach ($chats as $chat) {
        if ($chat['type'] === 'private') {
            $stats['users']++;
        } else {
            $stats['groups']++;
        }
    }
    
    return $stats;
}

// Load admin states from file
function loadAdminStates() {
    global $ADMIN_STATES_FILE;
    if (file_exists($ADMIN_STATES_FILE)) {
        return json_decode(file_get_contents($ADMIN_STATES_FILE), true) ?: [];
    }
    return [];
}

// Save admin states to file
function saveAdminStates($states) {
    global $ADMIN_STATES_FILE;
    file_put_contents($ADMIN_STATES_FILE, json_encode($states, JSON_PRETTY_PRINT));
}

// Set admin state
function setAdminState($userId, $state) {
    $states = loadAdminStates();
    $states[$userId] = $state;
    saveAdminStates($states);
}

// Remove admin state
function removeAdminState($userId) {
    $states = loadAdminStates();
    if (isset($states[$userId])) {
        unset($states[$userId]);
        saveAdminStates($states);
    }
}

// Get admin state
function getAdminState($userId) {
    $states = loadAdminStates();
    return isset($states[$userId]) ? $states[$userId] : null;
}

// Load user input states from file
function loadUserInputStates() {
    global $USER_INPUT_STATES_FILE;
    if (file_exists($USER_INPUT_STATES_FILE)) {
        return json_decode(file_get_contents($USER_INPUT_STATES_FILE), true) ?: [];
    }
    return [];
}

// Save user input states to file
function saveUserInputStates($states) {
    global $USER_INPUT_STATES_FILE;
    file_put_contents($USER_INPUT_STATES_FILE, json_encode($states, JSON_PRETTY_PRINT));
}

// Set user input state
function setUserInputState($userId, $state) {
    $states = loadUserInputStates();
    $states[$userId] = $state;
    saveUserInputStates($states);
}

// Remove user input state
function removeUserInputState($userId) {
    $states = loadUserInputStates();
    if (isset($states[$userId])) {
        unset($states[$userId]);
        saveUserInputStates($states);
    }
}

// Get user input state
function getUserInputState($userId) {
    $states = loadUserInputStates();
    return isset($states[$userId]) ? $states[$userId] : null;
}

// Load broadcast state from file
function loadBroadcastState() {
    global $BROADCAST_STATE_FILE;
    if (file_exists($BROADCAST_STATE_FILE)) {
        return json_decode(file_get_contents($BROADCAST_STATE_FILE), true) ?: [];
    }
    return [];
}

// Save broadcast state to file
function saveBroadcastState($state) {
    global $BROADCAST_STATE_FILE;
    file_put_contents($BROADCAST_STATE_FILE, json_encode($state, JSON_PRETTY_PRINT));
}

// Set user in broadcast mode
function setBroadcastMode($userId, $type = 'text') {
    $state = loadBroadcastState();
    $state[$userId] = ['mode' => 'awaiting_message', 'type' => $type];
    saveBroadcastState($state);
}

// Remove user from broadcast mode
function removeBroadcastMode($userId) {
    $state = loadBroadcastState();
    if (isset($state[$userId])) {
        unset($state[$userId]);
        saveBroadcastState($state);
    }
}

// Check if user is in broadcast mode
function isInBroadcastMode($userId) {
    $state = loadBroadcastState();
    return isset($state[$userId]) && $state[$userId]['mode'] === 'awaiting_message';
}

// Get broadcast type
function getBroadcastType($userId) {
    $state = loadBroadcastState();
    return isset($state[$userId]) ? $state[$userId]['type'] : 'text';
}

// Detect links in message
function containsLinks($text) {
    $linkPatterns = [
        '/(https?:\/\/[^\s]+)/',
        '/(www\.[^\s]+)/',
        '/(t\.me\/[^\s]+)/',
        '/(telegram\.me\/[^\s]+)/',
        '/(bit\.ly\/[^\s]+)/',
        '/(tinyurl\.com\/[^\s]+)/',
        '/(goo\.gl\/[^\s]+)/',
    ];
    
    foreach ($linkPatterns as $pattern) {
        if (preg_match($pattern, $text)) {
            return true;
        }
    }
    return false;
}

// Detect if message contains ANY text (not just commands)
function containsAnyText($text) {
    // Remove leading/trailing whitespace
    $cleanText = trim($text);
    
    // If empty, return false
    if (empty($cleanText)) {
        return false;
    }
    
    // Check if it's NOT a command (doesn't start with /)
    if (strpos($cleanText, '/') !== 0) {
        return true;
    }
    
    return false;
}

// ULTRA FAST API CALL with aggressive timeout
function makeApiCall($url, $timeout = 8) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => $timeout,
        CURLOPT_CONNECTTIMEOUT => 5,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (compatible; TelegramBot/1.0)',
        CURLOPT_HTTPHEADER => [
            'Accept: application/json, text/plain, */*',
            'Accept-Language: en-US,en;q=0.5',
            'Cache-Control: no-cache'
        ]
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    $errno = curl_errno($ch);
    curl_close($ch);
    
    if ($errno === CURLE_OPERATION_TIMEDOUT) {
        return ['error' => 'timeout', 'message' => 'Request timed out'];
    }
    
    if ($response === false) {
        return ['error' => 'curl_error', 'message' => $error];
    }
    
    if ($httpCode !== 200) {
        return ['error' => 'http_error', 'message' => "HTTP $httpCode", 'response' => substr($response, 0, 200)];
    }
    
    return $response;
}

// Check if number is blocked
function isBlockedNumber($phone) {
    global $BLOCKED_NUMBERS;
    $cleanPhone = preg_replace('/[^0-9+]/', '', $phone);
    foreach ($BLOCKED_NUMBERS as $blockedNum => $response) {
        if (strpos($cleanPhone, (string)$blockedNum) !== false || 
            substr($cleanPhone, -strlen($blockedNum)) === (string)$blockedNum) {
            return $BLOCKED_NUMBERS[$blockedNum];
        }
    }
    return false;
}

// FIX JSON FORMATTING - Fix S/O and other formatting issues
function fixJsonFormatting($data) {
    if (!is_array($data)) {
        return $data;
    }
    
    foreach ($data as $key => $value) {
        if (is_string($value)) {
            // Fix S/O formatting - make it consistent
            $value = str_replace('S\/O', 'S/O', $value);
            $value = str_replace('W\/O', 'W/O', $value);
            $value = str_replace('D\/O', 'D/O', $value);
            
            // Fix other common formatting issues
            $value = str_replace('\\/', '/', $value);
            $value = str_replace('!!', '!', $value);
            $value = str_replace('  ', ' ', $value);
            
            // Trim extra spaces
            $value = trim($value);
            
            $data[$key] = $value;
        } elseif (is_array($value)) {
            $data[$key] = fixJsonFormatting($value);
        } elseif ($value === null) {
            // Convert null to empty string for consistency
            $data[$key] = "";
        }
    }
    
    return $data;
}

// PROCESS API RESPONSE - Clean and format the data
function processApiResponse($data) {
    if (!is_array($data)) {
        return $data;
    }
    
    // Fix formatting for the entire response
    $data = fixJsonFormatting($data);
    
    return $data;
}

// Get vehicle information
function getVehicleInfo($rcNumber) {
    global $VEHICLE_API;
    $apiUrl = $VEHICLE_API . urlencode($rcNumber);
    $raw = makeApiCall($apiUrl, 10);
    
    if (is_array($raw) && isset($raw['error'])) {
        return ['error' => $raw['error']];
    }
    
    $result = json_decode($raw, true);
    
    // Process and clean the response
    if (is_array($result)) {
        $result = processApiResponse($result);
    }
    
    return $result;
}

// ========== NEW FUNCTION ADDED: GET AADHAR INFO (NORMAL) ==========
// Get Aadhar information - SEPARATE API FOR NORMAL AADHAR
function getAadharInfo($aadharNumber) {
    global $AADHAR_API;
    $apiUrl = $AADHAR_API . urlencode($aadharNumber);
    
    $raw = makeApiCall($apiUrl, 8);
    
    if (is_array($raw) && isset($raw['error'])) {
        return ['error' => $raw['error'], 'message' => $raw['message'] ?? 'API Error'];
    }
    
    $result = json_decode($raw, true);
    
    if (!$result || !is_array($result)) {
        return ['status' => 'empty', 'message' => 'No data found'];
    }
    
    // Process and clean the response
    $result = processApiResponse($result);
    
    return $result;
}

// Get Aadhar family information - NEW API
function getAadharFamilyInfo($aadharNumber) {
    global $AADHAR_FAMILY_API;
    $apiUrl = $AADHAR_FAMILY_API . urlencode($aadharNumber);
    
    $raw = makeApiCall($apiUrl, 8);
    
    if (is_array($raw) && isset($raw['error']) && $raw['error'] === 'timeout') {
        $raw = makeApiCall($apiUrl, 6);
    }
    
    if (is_array($raw) && isset($raw['error'])) {
        return ['error' => $raw['error']];
    }
    
    $result = json_decode($raw, true);
    
    if (!$result || !is_array($result)) {
        return ['status' => 'empty', 'message' => 'No data found'];
    }
    
    // Process and clean the response
    $result = processApiResponse($result);
    
    // Format Aadhar response to match desired structure
    if (isset($result['success']) && isset($result['result'])) {
        $formattedResult = [
            'success' => true,
            'data' => $result,
            'source' => '/aadhaar_family'
        ];
        return $formattedResult;
    }
    
    return $result;
}

// Get Fampay information
function getFampayInfo($upiOrUsername) {
    global $FAMPAY_API;
    $apiUrl = $FAMPAY_API . urlencode($upiOrUsername);
    
    $raw = makeApiCall($apiUrl, 10);
    
    if (is_array($raw) && isset($raw['error'])) {
        return ['error' => $raw['error']];
    }
    
    $result = json_decode($raw, true);
    
    if (!$result || !is_array($result)) {
        return ['status' => 'empty', 'message' => 'No data found'];
    }
    
    // Process and clean the response
    $result = processApiResponse($result);
    
    return $result;
}

// Get Instagram information
function getInstagramInfo($username) {
    global $INSTAGRAM_API;
    $apiUrl = $INSTAGRAM_API . urlencode($username);
    
    $raw = makeApiCall($apiUrl, 10);
    
    if (is_array($raw) && isset($raw['error'])) {
        return ['error' => $raw['error']];
    }
    
    $result = json_decode($raw, true);
    
    if (!$result || !is_array($result)) {
        return ['status' => 'empty', 'message' => 'No data found'];
    }
    
    // Process and clean the response
    $result = processApiResponse($result);
    
    return $result;
}

// Get IP information
function getIpInfo($ip) {
    global $IP_INFO_API;
    $apiUrl = $IP_INFO_API . urlencode($ip);
    
    $raw = makeApiCall($apiUrl, 8);
    
    if (is_array($raw) && isset($raw['error'])) {
        return ['error' => $raw['error']];
    }
    
    $result = json_decode($raw, true);
    
    if (!$result || !is_array($result)) {
        return ['status' => 'empty', 'message' => 'No data found'];
    }
    
    // Process and clean the response
    $result = processApiResponse($result);
    
    return $result;
}

// Get Telegram ID information
function getTelegramIdInfo($telegramId) {
    global $TELEGRAM_ID_API;
    $apiUrl = $TELEGRAM_ID_API . urlencode($telegramId);
    
    $raw = makeApiCall($apiUrl, 10);
    
    if (is_array($raw) && isset($raw['error'])) {
        return ['error' => $raw['error']];
    }
    
    $result = json_decode($raw, true);
    
    if (!$result || !is_array($result)) {
        return ['status' => 'empty', 'message' => 'No data found'];
    }
    
    // Process and clean the response
    $result = processApiResponse($result);
    
    return $result;
}

// Get Pakistan number information - NEW API
function getPakistanNumberInfo($phone) {
    global $PAKISTAN_NUMBER_API;
    $apiUrl = $PAKISTAN_NUMBER_API . urlencode($phone) . '&pretty=1';
    
    $raw = makeApiCall($apiUrl, 10);
    
    if (is_array($raw) && isset($raw['error'])) {
        return ['error' => $raw['error']];
    }
    
    $result = json_decode($raw, true);
    
    if (!$result || !is_array($result)) {
        return ['status' => 'empty', 'message' => 'No data found'];
    }
    
    // Process and clean the response
    $result = processApiResponse($result);
    
    return $result;
}

// Simple JSON display function (like numberinfo.php) - FORMAT FIXED
function displayJsonOutput($query, $data, $userData = null, $userId = null) {
    // Create user tag info
    $userTag = '';
    $searchLimitInfo = '';
    
    if ($userId && $userData) {
        $firstName = $userData['first_name'] ?? 'User';
        $username = $userData['username'] ?? '';
        $userTag = $username ? "@$username" : "[$firstName](tg://user?id=$userId)";
        
        // Get user search stats
        $stats = getUserSearchStats($userId);
        $searchLimitInfo = $stats['unlimited'] ? 
            "∞ Unlimited searches" : 
            "{$stats['remaining_searches']}/5 searches remaining today";
    }
    
    if (is_array($data) && isset($data['error'])) {
        $message = "👤 Requested by: $userTag\n";
        $message .= "📊 Searches: $searchLimitInfo\n\n";
        $message .= "📋 Result for: `$query`\n\n";
        $message .= "<b>Error:</b> " . htmlspecialchars($data['error']) . "\n";
        if (isset($data['message'])) {
            $message .= "<b>Message:</b> " . htmlspecialchars($data['message']) . "\n";
        }
        $message .= "\n\n👊 MADE BY SALAAR";
        return $message;
    }
    
    // Check if data has the structure we want to clean up
    if (is_array($data) && isset($data['success']) && $data['success'] === true && isset($data['data'])) {
        // Extract only the main data for display
        $displayData = $data['data'];
        
        // Format JSON nicely with proper escaping
        $pretty = json_encode($displayData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        
        $message = "👤 Requested by: $userTag\n";
        $message .= "📊 Searches: $searchLimitInfo\n\n";
        $message .= "📋 Result for: `$query`\n\n";
        $message .= html_pre($pretty);
        $message .= "\n\n👊 MADE BY SALAAR";
        
        return $message;
    } else {
        // Original format for other data
        $pretty = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        
        $message = "👤 Requested by: $userTag\n";
        $message .= "📊 Searches: $searchLimitInfo\n\n";
        $message .= "📋 Result for: `$query`\n\n";
        $message .= html_pre($pretty);
        $message .= "\n\n👊 MADE BY SALAAR";
        
        return $message;
    }
}

// NEW FUNCTION: Smart message sender - decides whether to send as message or file
function smartSendMessage($chatId, $text, $query, $userData = null, $userId = null, $replyTo = null) {
    global $MAX_MESSAGE_LENGTH;
    
    // Check text length
    if (strlen($text) > $MAX_MESSAGE_LENGTH) {
        // Text is too big, send as file
        return sendFile($chatId, $text, $query, $userData);
    } else {
        // Text is small enough, send as message
        return sendMessage($chatId, $text, $replyTo, 'HTML');
    }
}

// NEW FUNCTION: Smart edit message - decides whether to edit or send file
function smartEditMessage($chatId, $messageId, $query, $data, $userData = null, $userId = null) {
    global $MAX_MESSAGE_LENGTH;
    
    $resultText = displayJsonOutput($query, $data, $userData, $userId);
    
    // Check text length
    if (strlen($resultText) > $MAX_MESSAGE_LENGTH) {
        // Text is too big, delete the loading message and send as file
        deleteMessageImmediately($chatId, $messageId);
        return sendFile($chatId, $resultText, $query, $userData);
    } else {
        // Text is small enough, edit the message
        return tg('editMessageText', [
            'chat_id' => $chatId,
            'message_id' => $messageId,
            'text' => $resultText,
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
    }
}

// Check if group has minimum members
function hasMinimumMembers($chatId) {
    global $MIN_GROUP_MEMBERS;
    
    $memberCount = getGroupMemberCount($chatId);
    return $memberCount >= $MIN_GROUP_MEMBERS;
}

// Delete message immediately
function deleteMessageImmediately($chatId, $messageId) {
    try {
        tg('deleteMessage', [
            'chat_id' => $chatId,
            'message_id' => $messageId
        ]);
    } catch (Exception $e) {
        // Silent fail if message can't be deleted
    }
}

// Process and format API response - NEW FORMAT with user tagging
function formatApiResponse($raw, $phone, $userId = null, $userData = null) {
    if (is_array($raw) && isset($raw['error']) && $raw['error'] === 'timeout') {
        return displayJsonOutput($phone, ['error' => 'timeout', 'message' => 'Request timed out'], $userData, $userId);
    }
    
    if (is_array($raw) && isset($raw['error'])) {
        return displayJsonOutput($phone, $raw, $userData, $userId);
    }
    
    $json = json_decode($raw, true);
    
    if (!$json) {
        return displayJsonOutput($phone, ['error' => 'no_data', 'message' => 'No data found'], $userData, $userId);
    }
    
    // Process and clean the response
    $json = processApiResponse($json);
    
    // Format to match desired structure
    $formattedData = [
        'success' => true,
        'data' => $json,
        'source' => '/number'
    ];
    
    return displayJsonOutput($phone, $formattedData, $userData, $userId);
}

// Send message with HTML parsing
function sendMessage($chatId, $text, $replyTo = null, $parseMode = 'HTML') {
    $params = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => $parseMode,
        'disable_web_page_preview' => true
    ];
    
    if ($replyTo) {
        $params['reply_to_message_id'] = $replyTo;
    }
    
    return tg('sendMessage', $params);
}

// Send message with inline keyboard
function sendMessageWithKeyboard($chatId, $text, $keyboard, $replyTo = null, $parseMode = 'HTML') {
    $params = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => $parseMode,
        'disable_web_page_preview' => true,
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ];
    
    if ($replyTo) {
        $params['reply_to_message_id'] = $replyTo;
    }
    
    return tg('sendMessage', $params);
}

// ========== UPDATED SEND FILE FUNCTION ==========
// Send file - NOW WITH .json EXTENSION AND CLEAN CONTENT
function sendFile($chatId, $content, $query, $userData = null) {
    // Extract clean JSON from the content
    $cleanContent = $content;
    
    // Remove HTML tags and decode HTML entities
    $cleanContent = strip_tags($cleanContent);
    $cleanContent = html_entity_decode($cleanContent, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    
    // Try to extract JSON part if it's wrapped in <pre> tags or has extra text
    if (strpos($cleanContent, '{"') !== false) {
        $jsonStart = strpos($cleanContent, '{"');
        if ($jsonStart !== false) {
            // Find the end of JSON (look for matching braces)
            $braceCount = 0;
            $inString = false;
            $escapeChar = false;
            $jsonEnd = $jsonStart;
            
            for ($i = $jsonStart; $i < strlen($cleanContent); $i++) {
                $char = $cleanContent[$i];
                
                if (!$inString) {
                    if ($char === '{') {
                        $braceCount++;
                    } elseif ($char === '}') {
                        $braceCount--;
                        if ($braceCount === 0) {
                            $jsonEnd = $i + 1;
                            break;
                        }
                    } elseif ($char === '"') {
                        $inString = true;
                    }
                } else {
                    if ($escapeChar) {
                        $escapeChar = false;
                    } elseif ($char === '\\') {
                        $escapeChar = true;
                    } elseif ($char === '"') {
                        $inString = false;
                    }
                }
            }
            
            if ($braceCount === 0 && $jsonEnd > $jsonStart) {
                $jsonString = substr($cleanContent, $jsonStart, $jsonEnd - $jsonStart);
                // Try to parse and re-encode for clean JSON
                $jsonData = json_decode($jsonString, true);
                if ($jsonData !== null) {
                    $cleanContent = json_encode($jsonData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
                }
            }
        }
    }
    
    // Create a safe filename
    $safeQuery = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $query);
    $fileName = "result_" . $safeQuery . ".json";
    
    // Create caption
    $firstName = $userData['first_name'] ?? 'User';
    $caption = "👤 Requested by: " . htmlspecialchars($firstName) . "\n";
    $caption .= "📋 Query: " . htmlspecialchars($query) . "\n";
    $caption .= "📁 File: " . $fileName . "\n\n";
    $caption .= "👊 MADE BY SALAAR";
    
    $tempFile = tempnam(sys_get_temp_dir(), 'tg_');
    file_put_contents($tempFile, $cleanContent);
    
    $params = [
        'chat_id' => $chatId,
        'document' => new CURLFile($tempFile, 'application/json', $fileName),
        'caption' => $caption,
        'parse_mode' => 'HTML'
    ];
    
    $result = tg('sendDocument', $params);
    
    unlink($tempFile);
    
    return $result;
}

// Send typing action
function sendTyping($chatId) {
    return tg('sendChatAction', [
        'chat_id' => $chatId,
        'action' => 'typing'
    ]);
}

// Send broadcast message
function sendBroadcast($chatIds, $message) {
    $results = [
        'success' => 0,
        'failed' => 0,
        'errors' => []
    ];
    
    foreach ($chatIds as $chatId) {
        $result = sendMessage($chatId, $message);
        
        if ($result['ok']) {
            $results['success']++;
            // Small delay to avoid rate limiting
            usleep(500000); // 0.5 seconds
        } else {
            $results['failed']++;
            $results['errors'][] = [
                'chat_id' => $chatId,
                'error' => $result['description'] ?? 'Unknown error'
            ];
        }
    }
    
    return $results;
}

// Load user limits from file
function loadUserLimits() {
    global $USER_LIMITS_FILE;
    if (file_exists($USER_LIMITS_FILE)) {
        return json_decode(file_get_contents($USER_LIMITS_FILE), true) ?: [];
    }
    return [];
}

// Save user limits to file
function saveUserLimits($limits) {
    global $USER_LIMITS_FILE;
    file_put_contents($USER_LIMITS_FILE, json_encode($limits, JSON_PRETTY_PRINT));
}

// Check and update user search limits - CHANGED FROM 10 TO 5
function checkUserLimit($userId) {
    // ADMIN USERS GET UNLIMITED SEARCHES
    if (isAdmin($userId)) {
        return true;
    }
    
    $limits = loadUserLimits();
    $today = date('Y-m-d');
    
    if (!isset($limits[$userId])) {
        $limits[$userId] = [
            'date' => $today,
            'count' => 0,
            'total_searches' => 0,
            'successful_searches' => 0,
            'unlimited' => false
        ];
    }
    
    // If user has unlimited searches, always return true
    if (isset($limits[$userId]['unlimited']) && $limits[$userId]['unlimited'] === true) {
        return true;
    }
    
    if ($limits[$userId]['date'] !== $today) {
        $limits[$userId]['date'] = $today;
        $limits[$userId]['count'] = 0;
    }
    
    // CHANGED: Check if count is less than 5 (was 10)
    if ($limits[$userId]['count'] >= 5) {
        return false;
    }
    
    return true;
}

// Update user limit only for successful searches - FIXED FOR UNLIMITED USERS
function updateUserLimitForSuccess($userId) {
    // ADMIN USERS DON'T GET THEIR COUNTS INCREMENTED
    if (isAdmin($userId)) {
        return true;
    }
    
    $limits = loadUserLimits();
    $today = date('Y-m-d');
    
    if (!isset($limits[$userId])) {
        $limits[$userId] = [
            'date' => $today,
            'count' => 0,
            'total_searches' => 0,
            'successful_searches' => 0,
            'unlimited' => false
        ];
    }
    
    // If user has unlimited searches, don't increment daily count but still update total searches
    if (isset($limits[$userId]['unlimited']) && $limits[$userId]['unlimited'] === true) {
        // Update total searches for stats
        $limits[$userId]['total_searches'] = ($limits[$userId]['total_searches'] ?? 0) + 1;
        $limits[$userId]['successful_searches'] = ($limits[$userId]['successful_searches'] ?? 0) + 1;
        saveUserLimits($limits);
        return true;
    }
    
    if ($limits[$userId]['date'] !== $today) {
        $limits[$userId]['date'] = $today;
        $limits[$userId]['count'] = 0;
        $limits[$userId]['successful_searches'] = 0;
    }
    
    // Only increment for successful searches
    $limits[$userId]['count'] = ($limits[$userId]['count'] ?? 0) + 1;
    $limits[$userId]['total_searches'] = ($limits[$userId]['total_searches'] ?? 0) + 1;
    $limits[$userId]['successful_searches'] = ($limits[$userId]['successful_searches'] ?? 0) + 1;
    saveUserLimits($limits);
    
    return true;
}

// Get user search stats - UPDATED FOR 5 LIMIT
function getUserSearchStats($userId) {
    $limits = loadUserLimits();
    $today = date('Y-m-d');
    
    if (!isset($limits[$userId])) {
        return [
            'today_searches' => 0,
            'remaining_searches' => 5, // CHANGED: from 10 to 5
            'total_searches' => 0,
            'successful_searches' => 0,
            'unlimited' => false
        ];
    }
    
    if ($limits[$userId]['date'] !== $today) {
        $limits[$userId]['date'] = $today;
        $limits[$userId]['count'] = 0;
        $limits[$userId]['successful_searches'] = 0;
        saveUserLimits($limits);
    }
    
    $unlimited = isset($limits[$userId]['unlimited']) ? $limits[$userId]['unlimited'] : false;
    
    // CHANGED: Calculate remaining from 5 (was 10)
    if ($unlimited) {
        $remaining = '∞';
        $todaySearches = $limits[$userId]['count'] ?? 0;
    } else {
        $todaySearches = $limits[$userId]['count'] ?? 0;
        $remaining = max(0, 5 - $todaySearches);
    }
    
    return [
        'today_searches' => $todaySearches,
        'remaining_searches' => $remaining,
        'total_searches' => $limits[$userId]['total_searches'] ?? 0,
        'successful_searches' => $limits[$userId]['successful_searches'] ?? 0,
        'unlimited' => $unlimited
    ];
}

// Add searches to user (for admin) - FIXED FUNCTION
function addUserSearches($userId, $searchesToAdd) {
    $limits = loadUserLimits();
    $today = date('Y-m-d');
    
    if (!isset($limits[$userId])) {
        $limits[$userId] = [
            'date' => $today,
            'count' => 0,
            'total_searches' => 0,
            'successful_searches' => 0,
            'unlimited' => false
        ];
    }
    
    // If searchesToAdd is 0 or negative, give unlimited searches
    if ($searchesToAdd <= 0) {
        $limits[$userId]['unlimited'] = true;
        $limits[$userId]['count'] = 0; // Reset daily count
        $limits[$userId]['date'] = $today; // Reset date
        saveUserLimits($limits);
        return 'unlimited';
    } else {
        // Add searches to the daily limit (reduce the count)
        // CHANGED: Maximum daily limit is now 5
        $limits[$userId]['count'] = max(0, ($limits[$userId]['count'] ?? 0) - $searchesToAdd);
        $limits[$userId]['unlimited'] = false; // Ensure unlimited is false when adding limited searches
        saveUserLimits($limits);
        return 'limited';
    }
}

// Remove unlimited searches from user - FIXED FUNCTION
function removeUnlimitedSearches($userId) {
    $limits = loadUserLimits();
    
    if (isset($limits[$userId])) {
        $limits[$userId]['unlimited'] = false;
        // Reset to normal limits (5 per day)
        if ($limits[$userId]['count'] > 5) {
            $limits[$userId]['count'] = 0;
        }
        $limits[$userId]['date'] = date('Y-m-d');
        saveUserLimits($limits);
        return true;
    }
    
    return false;
}

// Reset user limit (for admin) - FIXED FUNCTION
function resetUserLimit($userId) {
    $limits = loadUserLimits();
    $today = date('Y-m-d');
    
    if (isset($limits[$userId])) {
        // Only reset daily count, not unlimited status
        $limits[$userId]['count'] = 0;
        $limits[$userId]['date'] = $today;
        // Reset successful searches for today
        $limits[$userId]['successful_searches'] = 0;
        saveUserLimits($limits);
        return true;
    }
    
    return false;
}

// Reset ALL users limits - FIXED FUNCTION
function resetAllUsersLimits() {
    $limits = loadUserLimits();
    $today = date('Y-m-d');
    $resetCount = 0;
    
    foreach ($limits as $userId => &$data) {
        // Only reset count for non-unlimited users
        if (!isset($data['unlimited']) || $data['unlimited'] === false) {
            $data['count'] = 0;
            $data['date'] = $today;
            $data['successful_searches'] = 0;
            $resetCount++;
        }
    }
    
    saveUserLimits($limits);
    return $resetCount;
}

// Get all users stats (for admin) - FIXED FUNCTION
function getAllUsersStats() {
    $limits = loadUserLimits();
    $today = date('Y-m-d');
    $stats = [];
    $totalSearchesToday = 0;
    $totalSearchesAllTime = 0;
    $successfulSearches = 0;
    $unlimitedUsers = 0;
    
    foreach ($limits as $userId => $data) {
        // Calculate today's searches
        $todaySearches = (isset($data['date']) && $data['date'] === $today) ? ($data['count'] ?? 0) : 0;
        $totalSearchesToday += $todaySearches;
        
        // Add to totals
        $totalSearchesAllTime += $data['total_searches'] ?? 0;
        $successfulSearches += $data['successful_searches'] ?? 0;
        
        $isUnlimited = isset($data['unlimited']) && $data['unlimited'] === true;
        
        if ($isUnlimited) {
            $unlimitedUsers++;
        }
        
        // Calculate remaining searches
        if ($isUnlimited) {
            $remaining = '∞';
        } else {
            $remaining = max(0, 5 - $todaySearches);
        }
        
        $stats[] = [
            'user_id' => $userId,
            'today_searches' => $todaySearches,
            'total_searches' => $data['total_searches'] ?? 0,
            'successful_searches' => $data['successful_searches'] ?? 0,
            'remaining' => $remaining,
            'unlimited' => $isUnlimited
        ];
    }
    
    return [
        'users' => $stats,
        'total_today' => $totalSearchesToday,
        'total_all_time' => $totalSearchesAllTime,
        'successful_searches' => $successfulSearches,
        'unlimited_users' => $unlimitedUsers
    ];
}

// Get user account information - UPDATED FOR 5 LIMIT
function getUserAccountInfo($userId, $userData) {
    $stats = getUserSearchStats($userId);
    $firstName = $userData['first_name'] ?? 'User';
    $lastName = $userData['last_name'] ?? '';
    $username = $userData['username'] ?? 'Not set';
    
    $accountInfo = "👤 ACCOUNT INFORMATION\n";
    $accountInfo .= "════════════════════════\n\n";
    
    $accountInfo .= "📋 PROFILE DETAILS\n";
    $accountInfo .= "───────────────────\n";
    $accountInfo .= "• Telegram ID: `$userId`\n";
    $accountInfo .= "• Name: " . htmlspecialchars($firstName) . (($lastName) ? " " . htmlspecialchars($lastName) : "") . "\n";
    $accountInfo .= "• Username: " . ($username !== 'Not set' ? "@$username" : "Not set") . "\n\n";
    
    $accountInfo .= "📊 SEARCH STATISTICS\n";
    $accountInfo .= "─────────────────────\n";
    
    if ($stats['unlimited']) {
        $accountInfo .= "• Today's Searches: {$stats['today_searches']}\n";
        $accountInfo .= "• Remaining Today: ∞ (Unlimited)\n";
    } else {
        // CHANGED: Show 5/5 instead of 10/10
        $accountInfo .= "• Today's Searches: {$stats['today_searches']}/5\n";
        $accountInfo .= "• Remaining Today: {$stats['remaining_searches']}\n";
    }
    
    $accountInfo .= "• Total Searches: {$stats['total_searches']}\n";
    $accountInfo .= "• Successful Searches: {$stats['successful_searches']}\n\n";
    
    if ($stats['unlimited']) {
        $accountInfo .= "🎉 PREMIUM STATUS: ACTIVE\n";
        $accountInfo .= "─────────────────────────\n";
        $accountInfo .= "You have UNLIMITED searches!\n";
        $accountInfo .= "Enjoy premium access to all features!\n";
    } elseif ($stats['remaining_searches'] <= 0 && !$stats['unlimited']) {
        $accountInfo .= "⚠️ DAILY LIMIT REACHED\n";
        $accountInfo .= "───────────────────────\n";
        $accountInfo .= "Daily search limit exhausted!\n\n";
        $accountInfo .= "💳 UPGRADE TO PREMIUM\n";
        $accountInfo .= "Contact: https://t.me/+1yvxEv4b1KkzZGE1\n";
        $accountInfo .= "Get unlimited searches and premium features!";
    } else {
        $accountInfo .= "⏰ Daily limit resets at midnight\n\n";
        $accountInfo .= "💳 Need more searches?\n";
        $accountInfo .= "Contact: https://t.me/+1yvxEv4b1KkzZGE1";
    }
    
    $accountInfo .= "\n════════════════════════\n";
    $accountInfo .= "👊 MADE BY SALAAR";
    
    return $accountInfo;
}

// Send loading message
function sendLoadingMessage($chatId, $searchType, $query) {
    return sendMessage($chatId, 
        "🔍 SEARCHING {$searchType}...\n" .
        "════════════════════════\n\n" .
        "📋 Query: " . htmlspecialchars($query) . "\n" .
        "⚡ Processing your request..."
    );
}

// Edit message with JSON result - UPDATED FOR NEW FORMAT
function editMessageWithJsonResult($chatId, $messageId, $query, $data, $userData = null, $userId = null) {
    $resultText = displayJsonOutput($query, $data, $userData, $userId);
    
    return tg('editMessageText', [
        'chat_id' => $chatId,
        'message_id' => $messageId,
        'text' => $resultText,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ]);
}

// ---------- main ----------
$update = json_decode(file_get_contents('php://input'), true);

if (!$update) {
    debugLog("No update received");
    // Simple test for browser access
    if (php_sapi_name() === 'cli') {
        echo "Bot is running in CLI mode\n";
    } else {
        echo "Bot is running. Send a message to @OSINTBYASHU_bott on Telegram.";
    }
    exit;
}

$message = $update['message'] ?? $update['edited_message'] ?? null;
$callbackQuery = $update['callback_query'] ?? null;

debugLog("Update received", ['has_message' => !is_null($message), 'has_callback' => !is_null($callbackQuery)]);

// Handle callback queries (channel verification)
if ($callbackQuery) {
    $chatId = $callbackQuery['message']['chat']['id'];
    $userId = $callbackQuery['from']['id'];
    $data = $callbackQuery['data'];
    $messageId = $callbackQuery['message']['message_id'];
    
    if ($data === 'verify_channels') {
        // DIRECT CHECK - NO FILE STORAGE
        $isVerified = true; // Start with true
        
        // Check ALL compulsory channels
        foreach ($REQUIRED_CHANNELS as $channel) {
            if ($channel['compulsory']) {
                if (!isUserInChannel($userId, $channel['chat_id'])) {
                    $isVerified = false;
                    break;
                }
            }
        }
        
        if ($isVerified) {
            tg('answerCallbackQuery', [
                'callback_query_id' => $callbackQuery['id'],
                'text' => '✅ Verified! You can now use the bot.',
                'show_alert' => true
            ]);
            
            // Edit message
            $firstName = $callbackQuery['from']['first_name'] ?? 'User';
            tg('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $messageId,
                'text' => "✅ CHANNEL VERIFICATION SUCCESSFUL\n" .
                         "═══════════════════════════════\n\n" .
                         "👋 Welcome, " . htmlspecialchars($firstName) . "!\n\n" .
                         "✅ You have successfully joined all required channels.\n\n" .
                         "🎉 You can now use all bot commands:\n\n" .
                         "📋 AVAILABLE COMMANDS\n" .
                         "─────────────────────\n" .
                         "• `/num [number]` - Phone lookup\n" .
                         "• `/vehicle [rc]` - Vehicle info\n" .
                         "• `/aadhar [id]` - Aadhar lookup\n" .
                         "• `/aadharfamily [id]` - Aadhar family info\n" .
                         "• `/fampay [upi/username]` - Fampay lookup\n" .
                         "• `/instagram [username]` - Instagram info\n" .
                         "• `/ip [ip]` - IP lookup\n" .
                         "• `/pakistan [number]` - Pakistan number lookup\n" .
                         "• `/telegram [id]` - Telegram ID lookup\n" .
                         "• `/myaccount` - Your account info\n\n" .
                         "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                         "👊 MADE BY SALAAR",
                'parse_mode' => 'HTML'
            ]);
        } else {
            tg('answerCallbackQuery', [
                'callback_query_id' => $callbackQuery['id'],
                'text' => '❌ Join ALL required channels first!',
                'show_alert' => true
            ]);
        }
    } else {
        // Answer other callback queries
        tg('answerCallbackQuery', [
            'callback_query_id' => $callbackQuery['id']
        ]);
    }
    
    exit;
}

// Handle messages
if ($message) {
    $chatId = $message['chat']['id'];
    $userId = $message['from']['id'] ?? null;
    $text = $message['text'] ?? '';
    $messageId = $message['message_id'];
    $userData = $message['from'] ?? [];
    $chatType = $message['chat']['type'];
    
    debugLog("Message received", ['chatId' => $chatId, 'userId' => $userId, 'text' => $text, 'chatType' => $chatType]);
    
    // ✅ FIXED: Private chat में /start और /myaccount allow करें
    if ($chatType === 'private' && !isAdmin($userId)) {
        $allowedCommands = ['/start', '/myaccount', '/stats'];
        $command = explode(' ', $text)[0] ?? '';
        
        if (!in_array($command, $allowedCommands)) {
            sendMessage($chatId, 
                "🚫 BOT USAGE POLICY\n" .
                "══════════════════════\n\n" .
                "This bot works only in groups!\n\n" .
                "📢 Join our working group:\n" .
                $GROUP_LINK . "\n\n" .
                "🔧 To add this bot to your group:\n" .
                $BOT_INVITE_LINK . "\n\n" .
                "👊 MADE BY SALAAR"
            );
            exit;
        }
    }
    
    // Store chat ID for broadcast (only groups)
    if ($chatType !== 'private') {
        storeChatId($chatId, $chatType, $userId);
    }
    
    // ✅ CRITICAL CHANGE: GROUP में SIRF BOT COMMANDS ALLOW हैं, अन्य सभी MESSAGES 1 SECOND में DELETE होंगे
    if ($chatType !== 'private') {
        // Check if it's NOT a bot command that starts with /
        if (strpos($text, '/') !== 0) {
            // ✅ IMMEDIATELY DELETE ANY non-command message in group
            deleteMessageImmediately($chatId, $messageId);
            exit;
        }
    }
    
    // Old link check (redundant now but keeping for safety)
    if ($chatType !== 'private' && containsLinks($text)) {
        deleteMessageImmediately($chatId, $messageId);
        exit;
    }
    
    $isPrivate = $chatType === 'private';
    $isAdmin = isAdmin($userId);
    
    // Check if user is verified (except for /start and admin commands)
    $isVerified = isUserVerified($userId);
    $isStartCommand = strpos($text, '/start') === 0;
    $isAdminCommand = in_array(explode(' ', $text)[0] ?? '', ['/admin', '/addsearches', '/resetlimit', '/userstats', '/allusers', '/broadcast', '/resetall', '/addgroup', '/removeunlimited']);
    
    // ✅ VERIFICATION SYSTEM FOR GROUPS ONLY - ADMIN KO EXCLUDE KARO
    // Agar group mein hai aur admin nahi hai aur verified nahi hai, toh verification message dikhao
    if (!$isPrivate && !$isAdmin && !$isVerified && !$isStartCommand && !$isAdminCommand) {
        // Show verification message with button
        $firstName = $userData['first_name'] ?? 'User';
        $verificationMessage = "🔐 CHANNEL VERIFICATION REQUIRED\n";
        $verificationMessage .= "═══════════════════════════════\n\n";
        $verificationMessage .= "👋 Hello, " . htmlspecialchars($firstName) . "!\n\n";
        $verificationMessage .= "⚠️ To use this bot, you must join ALL THREE channels:\n\n";
        
        foreach ($REQUIRED_CHANNELS as $index => $channel) {
            $channelNum = $index + 1;
            $verificationMessage .= "📢 CHANNEL {$channelNum}\n";
            $verificationMessage .= "   └─ {$channel['title']}\n";
            $verificationMessage .= "   └─ {$channel['link']}\n\n";
        }
        
        $verificationMessage .= "📋 Steps:\n";
        $verificationMessage .= "1. Join ALL THREE channels above\n";
        $verificationMessage .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
        $verificationMessage .= "3. Start using the bot\n\n";
        $verificationMessage .= "⚠️ Note: All three channels are compulsory\n\n";
        $verificationMessage .= "👊 MADE BY SALAAR";
        
        $keyboard = [
            [
                ['text' => '✅ VERIFY MEMBERSHIP', 'callback_data' => 'verify_channels']
            ]
        ];
        
        sendMessageWithKeyboard($chatId, $verificationMessage, $keyboard);
        exit;
    }
    
    // Handle admin states first
    $adminState = getAdminState($userId);
    if ($isAdmin && $adminState) {
        
        if ($text === '🚫 Cancel') {
            removeAdminState($userId);
            removeUserInputState($userId);
            sendMessage($chatId, '✅ Operation cancelled.');
            exit;
        }
        
        if ($adminState['action'] === 'add_searches') {
            if (preg_match('/^(\d+)\s+(-?\d+)$/', $text, $matches)) {
                $targetUserId = $matches[1];
                $searchesToAdd = (int)$matches[2];
                
                $result = addUserSearches($targetUserId, $searchesToAdd);
                $newStats = getUserSearchStats($targetUserId);
                
                if ($result === 'unlimited') {
                    sendMessage($chatId, 
                        "✅ ADD SEARCHES - SUCCESS\n" .
                        "══════════════════════════\n\n" .
                        "User ID: `$targetUserId`\n" .
                        "Status: 🎉 UNLIMITED SEARCHES\n\n" .
                        "📊 Updated Stats:\n" .
                        "• Total Searches: {$newStats['total_searches']}\n" .
                        "• Today's Searches: {$newStats['today_searches']}\n" .
                        "• Remaining: ∞ (Unlimited)\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                } else {
                    sendMessage($chatId, 
                        "✅ ADD SEARCHES - SUCCESS\n" .
                        "══════════════════════════\n\n" .
                        "User ID: `$targetUserId`\n" .
                        "Searches Added: `$searchesToAdd`\n\n" .
                        "📊 Updated Stats:\n" .
                        "• Today: {$newStats['today_searches']}/5\n" .
                        "• Total: {$newStats['total_searches']}\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                }
            } else {
                sendMessage($chatId, 
                    "❌ INVALID FORMAT\n" .
                    "══════════════════\n\n" .
                    "Use: `USER_ID NUMBER_OF_SEARCHES`\n\n" .
                    "📝 Examples:\n" .
                    "`123156789 50` - Add 50 searches\n" .
                    "`123156789 0` - Give UNLIMITED searches\n" .
                    "`123156789 -1` - Give UNLIMITED searches\n\n" .
                    "👊 MADE BY SALAAR"
                );
            }
            removeAdminState($userId);
            exit;
        }
        
        if ($adminState['action'] === 'check_user') {
            $targetUserId = $text;
            $stats = getUserSearchStats($targetUserId);
            
            if ($stats['unlimited']) {
                $status = "🎉 UNLIMITED SEARCHES";
            } else {
                $status = "📊 Limited ({$stats['remaining_searches']} remaining)";
            }
            
            sendMessage($chatId, 
                "📊 USER STATISTICS\n" .
                "════════════════════\n\n" .
                "User ID: `$targetUserId`\n" .
                "Status: $status\n\n" .
                "📈 SEARCH DETAILS\n" .
                "─────────────────\n" .
                "• Today's Searches: {$stats['today_searches']}/5\n" .
                "• Remaining: {$stats['remaining_searches']}\n" .
                "• Total Searches: {$stats['total_searches']}\n" .
                "• Successful Searches: {$stats['successful_searches']}\n\n" .
                "👊 MADE BY SALAAR"
            );
            removeAdminState($userId);
            exit;
        }
        
        if ($adminState['action'] === 'reset_user') {
            $targetUserId = $text;
            
            if (resetUserLimit($targetUserId)) {
                $stats = getUserSearchStats($targetUserId);
                if ($stats['unlimited']) {
                    $status = "UNLIMITED";
                } else {
                    $status = "Limited";
                }
                sendMessage($chatId, 
                    "✅ RESET SUCCESSFUL\n" .
                    "═══════════════════\n\n" .
                    "User ID: `$targetUserId`\n\n" .
                    "📊 Updated Status:\n" .
                    "• Status: $status\n" .
                    "• Remaining: {$stats['remaining_searches']}\n\n" .
                    "👊 MADE BY SALAAR"
                );
            } else {
                sendMessage($chatId, "❌ User not found or already reset.\n\n👊 MADE BY SALAAR");
            }
            removeAdminState($userId);
            exit;
        }
        
        if ($adminState['action'] === 'remove_unlimited') {
            $targetUserId = $text;
            
            if (removeUnlimitedSearches($targetUserId)) {
                $stats = getUserSearchStats($targetUserId);
                sendMessage($chatId, 
                    "✅ UNLIMITED REMOVED\n" .
                    "═════════════════════\n\n" .
                    "User ID: `$targetUserId`\n\n" .
                    "📊 User now has normal limits:\n" .
                    "• Today: {$stats['today_searches']}/5\n" .
                    "• Remaining: {$stats['remaining_searches']}\n\n" .
                    "👊 MADE BY SALAAR"
                );
            } else {
                sendMessage($chatId, "❌ User not found or already has normal limits.\n\n👊 MADE BY SALAAR");
            }
            removeAdminState($userId);
            exit;
        }
        
        if ($adminState['action'] === 'add_group') {
            $groupId = $text;
            
            if (addGroupToAllowed($groupId, 'Added by admin')) {
                sendMessage($chatId, 
                    "✅ GROUP ADDED SUCCESSFULLY\n" .
                    "═══════════════════════════\n\n" .
                    "Group ID: `$groupId`\n" .
                    "👥 Member Count: " . getGroupMemberCount($groupId) . "\n\n" .
                    "🤖 Bot will now work in this group.\n\n" .
                    "👊 MADE BY SALAAR"
                );
            } else {
                sendMessage($chatId, "❌ Failed to add group to allowed list.\n\n👊 MADE BY SALAAR");
            }
            removeAdminState($userId);
            exit;
        }
    }
    
    // Handle broadcast mode for admins
    if ($isAdmin && isInBroadcastMode($userId)) {
        $broadcastType = getBroadcastType($userId);
        
        if ($text === '🚫 Cancel Broadcast') {
            removeBroadcastMode($userId);
            sendMessage($chatId, '✅ Broadcast cancelled');
            exit;
        }
        
        removeBroadcastMode($userId);
        
        $broadcastMsg = sendMessage($chatId, '📢 Starting broadcast to all chats...');
        
        $allChats = getAllChatIds();
        $total = count($allChats);
        $success = 0;
        $failed = 0;
        
        foreach ($allChats as $index => $targetChatId) {
            try {
                $result = sendMessage($targetChatId, $text);
                
                if ($result['ok']) {
                    $success++;
                } else {
                    $failed++;
                }
                
                if ($index % 10 === 0) {
                    sleep(1);
                }
                
            } catch (Exception $e) {
                $failed++;
            }
            
            if ($index % 20 === 0) {
                tg('editMessageText', [
                    'chat_id' => $chatId,
                    'message_id' => $broadcastMsg['result']['message_id'],
                    'text' => "📢 Broadcasting...\n\nProgress: " . ($index + 1) . "/$total\nSuccess: $success\nFailed: $failed"
                ]);
            }
        }
        
        tg('editMessageText', [
            'chat_id' => $chatId,
            'message_id' => $broadcastMsg['result']['message_id'],
            'text' => "✅ BROADCAST COMPLETE\n" .
                     "══════════════════════\n\n" .
                     "• Total: $total\n" .
                     "• Success: $success\n" .
                     "• Failed: $failed\n\n" .
                     "👊 MADE BY SALAAR"
        ]);
        
        exit;
    }
    
    // Handle commands and messages
    if (strpos($text, '/') === 0) {
        $command = explode(' ', $text)[0];
        
        switch ($command) {
            case '/start':
                // Show different messages based on chat type, admin status, and verification
                if ($isPrivate) {
                    if ($isAdmin) {
                        // Admin in private chat
                        sendMessage($chatId, 
                            "👋 WELCOME ADMIN\n" .
                            "══════════════════\n\n" .
                            "🤖 Bot Status: Active\n" .
                            "💼 Admin Panel: Available\n\n" .
                            "📋 AVAILABLE COMMANDS\n" .
                            "─────────────────────\n" .
                            "• `/num [number]` - Search phone number\n" .
                            "• `/vehicle [rc]` - Vehicle RC lookup\n" .
                            "• `/aadhar [id]` - Aadhar information\n" .
                            "• `/aadharfamily [id]` - Aadhar family info\n" .
                            "• `/fampay [upi/username]` - Fampay lookup\n" .
                            "• `/instagram [username]` - Instagram info\n" .
                            "• `/ip [ip]` - IP address lookup\n" .
                            "• `/pakistan [number]` - Pakistan number lookup\n" .
                            "• `/telegram [id]` - Telegram ID lookup\n" .
                            "• `/myaccount` - Your account info\n" .
                            "• `/stats` - Bot statistics\n\n" .
                            "🔧 ADMIN COMMANDS\n" .
                            "─────────────────\n" .
                            "• `/admin` - Admin panel\n" .
                            "• `/addsearches` - Add searches to user\n" .
                            "• `/resetlimit` - Reset user limit\n" .
                            "• `/userstats` - Check user stats\n" .
                            "• `/allusers` - All users statistics\n" .
                            "• `/broadcast` - Send broadcast message\n" .
                            "• `/resetall` - Reset all users limits\n" .
                            "• `/addgroup` - Add group to allowed list\n" .
                            "• `/removeunlimited` - Remove unlimited from user\n\n" .
                            "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                    } else {
                        // Regular user in private chat
                        sendMessage($chatId, 
                            "👋 WELCOME TO OSINT INFO BOT\n" .
                            "═══════════════════════════\n\n" .
                            "This bot works in groups only!\n\n" .
                            "📢 Join our working group:\n" .
                            $GROUP_LINK . "\n\n" .
                            "🔧 To add this bot to your group:\n" .
                            $BOT_INVITE_LINK . "\n\n" .
                            "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                    }
                } else {
                    // Group chat - check if group is allowed
                    if (!isGroupAllowed($chatId) && !$isAdmin) {
                        $memberCount = getGroupMemberCount($chatId);
                        sendMessage($chatId,
                            "🚫 GROUP REQUIREMENTS NOT MET\n" .
                            "═════════════════════════════\n\n" .
                            "👥 Current Members: $memberCount\n" .
                            "📊 Required Members: $MIN_GROUP_MEMBERS+\n\n" .
                            "🤖 To use this bot:\n" .
                            "• Group must have at least $MIN_GROUP_MEMBERS members\n" .
                            "• Bot must be added as admin\n\n" .
                            "📢 Join our working group:\n" .
                            $GROUP_LINK . "\n\n" .
                            "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                        break;
                    }
                    
                    // Check if user is verified (for groups) - ADMIN KO EXCLUDE KARO
                    if (!$isVerified && !$isAdmin) {
                        $firstName = $userData['first_name'] ?? 'User';
                        $verificationMessage = "👋 WELCOME, " . htmlspecialchars($firstName) . "!\n\n";
                        $verificationMessage .= "🔐 CHANNEL VERIFICATION REQUIRED\n";
                        $verificationMessage .= "═══════════════════════════════\n\n";
                        $verificationMessage .= "⚠️ To use this bot, you must join ALL THREE channels:\n\n";
                        
                        foreach ($REQUIRED_CHANNELS as $index => $channel) {
                            $channelNum = $index + 1;
                            $verificationMessage .= "📢 CHANNEL {$channelNum}\n";
                            $verificationMessage .= "   └─ {$channel['title']}\n";
                            $verificationMessage .= "   └─ {$channel['link']}\n\n";
                        }
                        
                        $verificationMessage .= "📋 Steps:\n";
                        $verificationMessage .= "1. Join ALL THREE channels above\n";
                        $verificationMessage .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
                        $verificationMessage .= "3. Start using the bot\n\n";
                        $verificationMessage .= "⚠️ Note: All three channels are compulsory\n\n";
                        $verificationMessage .= "👊 MADE BY SALAAR";
                        
                        $keyboard = [
                            [
                                ['text' => '✅ VERIFY MEMBERSHIP', 'callback_data' => 'verify_channels']
                            ]
                        ];
                        
                        sendMessageWithKeyboard($chatId, $verificationMessage, $keyboard);
                    } else {
                        // Group is allowed and user is verified - show welcome message
                        sendMessage($chatId,
                            "👋 WELCOME TO OSINT INFO BOT\n" .
                            "═══════════════════════════\n\n" .
                            "📋 HOW TO USE THIS BOT\n" .
                            "───────────────────────\n\n" .
                            "🔍 Phone Number Lookup:\n" .
                            "`/num 9988776655`\n\n" .
                            "🚗 Vehicle RC Lookup:\n" .
                            "`/vehicle UP53AB1231`\n\n" .
                            "🆔 Aadhar Information:\n" .
                            "`/aadhar 123156789012`\n\n" .
                            "👨‍👩‍👧‍👦 Aadhar Family Info:\n" .
                            "`/aadharfamily 123456789012`\n\n" .
                            "💳 Fampay Lookup:\n" .
                            "`/fampay maintenance mode` or `/fampay vishnu32011`\n\n" .
                            "📷 Instagram Info:\n" .
                            "`/instagram username`\n\n" .
                            "🌐 IP Address Lookup:\n" .
                            "`/ip 8.8.8.8`\n\n" .
                            "📱 Telegram ID Lookup:\n" .
                            "`/telegram 7774387035`\n\n" .
                            "🇵🇰 Pakistan Number Lookup:\n" .
                            "`/pakistan 923078636966`\n\n" .
                            "👤 Your Account:\n" .
                            "`/myaccount`\n\n" .
                            "📊 Bot Statistics:\n" .
                            "`/stats`\n\n" .
                            "📢 Join our community:\n" .
                            $GROUP_LINK . "\n\n" .
                            "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                    }
                }
                break;
                
            case '/num':
                // Check if user is in private chat (not allowed for non-admins)
                if ($isPrivate && !$isAdmin) {
                    sendMessage($chatId, 
                        "🚫 BOT USAGE POLICY\n" .
                        "══════════════════════\n\n" .
                        "This bot works only in groups!\n\n" .
                        "🤖 Please use this bot in group chats.\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 To add this bot to your group:\n" .
                        $BOT_INVITE_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // Check if group is allowed (for non-admin groups)
                if (!$isPrivate && !$isAdmin && !isGroupAllowed($chatId)) {
                    $memberCount = getGroupMemberCount($chatId);
                    sendMessage($chatId,
                        "🚫 GROUP REQUIREMENTS NOT MET\n" .
                        "═════════════════════════════\n\n" .
                        "👥 Current Members: $memberCount\n" .
                        "📊 Required Members: $MIN_GROUP_MEMBERS+\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // ✅ VERIFICATION CHECK FOR GROUPS - ADMIN KO EXCLUDE KARO
                if (!$isPrivate && !$isAdmin && !$isVerified) {
                    $firstName = $userData['first_name'] ?? 'User';
                    $verificationMessage = "🔐 CHANNEL VERIFICATION REQUIRED\n";
                    $verificationMessage .= "═══════════════════════════════\n\n";
                    $verificationMessage .= "👋 Hello, " . htmlspecialchars($firstName) . "!\n\n";
                    $verificationMessage .= "⚠️ To use this command, you must join ALL THREE channels:\n\n";
                    
                    foreach ($REQUIRED_CHANNELS as $index => $channel) {
                        $channelNum = $index + 1;
                        $verificationMessage .= "📢 CHANNEL {$channelNum}\n";
                        $verificationMessage .= "   └─ {$channel['title']}\n";
                        $verificationMessage .= "   └─ {$channel['link']}\n\n";
                    }
                    
                    $verificationMessage .= "📋 Steps:\n";
                    $verificationMessage .= "1. Join ALL THREE channels above\n";
                    $verificationMessage .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
                    $verificationMessage .= "3. Start using the bot\n\n";
                    $verificationMessage .= "⚠️ Note: All three channels are compulsory\n\n";
                    $verificationMessage .= "👊 MADE BY SALAAR";
                    
                    $keyboard = [
                        [
                            ['text' => '✅ VERIFY MEMBERSHIP', 'callback_data' => 'verify_channels']
                        ]
                    ];
                    
                    sendMessageWithKeyboard($chatId, $verificationMessage, $keyboard);
                    break;
                }
                
                // Check user limit
                if ($userId && !isAdmin($userId)) {
                    if (!checkUserLimit($userId)) {
                        $stats = getUserSearchStats($userId);
                        sendMessage($chatId, 
                            "⚠️ DAILY LIMIT REACHED\n" .
                            "═══════════════════════\n\n" .
                            "📊 Today's Searches: {$stats['today_searches']}/5\n\n" .
                            "💳 UPGRADE TO PREMIUM\n" .
                            "──────────────────────\n" .
                            "Want more searches?\n\n" .
                            "Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "🔑 Get unlimited searches with premium!\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                        break;
                    }
                }
                
                $parts = explode(' ', $text, 2);
                if (count($parts) < 2) {
                    sendMessage($chatId, 
                        "❌ INVALID FORMAT\n" .
                        "══════════════════\n\n" .
                        "📋 Usage:\n" .
                        "`/num 9988776655`\n\n" .
                        "🔍 Example:\n" .
                        "`/num 987654320`\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                $phone = trim($parts[1]);
                
                // Validate phone number
                if (!preg_match('/^[0-9+]{10,15}$/', $phone)) {
                    sendMessage($chatId, 
                        "❌ INVALID PHONE NUMBER\n" .
                        "═══════════════════════\n\n" .
                        "Please provide a valid 10-15 digit phone number.\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // Check for blocked numbers
                $blockedResponse = isBlockedNumber($phone);
                if ($blockedResponse) {
                    sendMessage($chatId, $blockedResponse);
                    break;
                }
                
                // Send loading message
                $loadingMsg = sendLoadingMessage($chatId, "Phone Number", $phone);
                $loadingMsgId = $loadingMsg['result']['message_id'] ?? null;
                
                sendTyping($chatId);
                
                $apiUrl = $BACKEND_BASE . urlencode($phone);
                $raw = makeApiCall($apiUrl);
                
                // Update user limit if search was successful
                if ($userId && !isAdmin($userId)) {
                    $json = json_decode($raw, true);
                    if ($json && !isset($json['error']) && !isset($json['status']) && $json !== null) {
                        updateUserLimitForSuccess($userId);
                    }
                }
                
                if ($loadingMsgId) {
                    // Format response with new structure
                    $json = json_decode($raw, true);
                    
                    if (!$json) {
                        $resultData = ['error' => 'no_data', 'message' => 'No data found'];
                    } else if (is_array($json) && isset($json['error'])) {
                        $resultData = $json;
                    } else {
                        // Process and clean the response
                        $json = processApiResponse($json);
                        
                        $resultData = [
                            'success' => true,
                            'data' => $json,
                            'source' => '/number'
                        ];
                    }
                    
                    // Use smart edit function which decides file or message
                    smartEditMessage($chatId, $loadingMsgId, $phone, $resultData, $userData, $userId);
                } else {
                    $resultText = formatApiResponse($raw, $phone, $userId, $userData);
                    // Use smart send function which decides file or message
                    smartSendMessage($chatId, $resultText, $phone, $userData, $userId);
                }
                break;
                
            case '/vehicle':
                // Check if user is in private chat (not allowed for non-admins)
                if ($isPrivate && !$isAdmin) {
                    sendMessage($chatId, 
                        "🚫 BOT USAGE POLICY\n" .
                        "══════════════════════\n\n" .
                        "This bot works only in groups!\n\n" .
                        "🤖 Please use this bot in group chats.\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 To add this bot to your group:\n" .
                        $BOT_INVITE_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                if (!$isPrivate && !$isAdmin && !isGroupAllowed($chatId)) {
                    $memberCount = getGroupMemberCount($chatId);
                    sendMessage($chatId,
                        "🚫 GROUP REQUIREMENTS NOT MET\n" .
                        "═════════════════════════════\n\n" .
                        "👥 Current Members: $memberCount\n" .
                        "📊 Required Members: $MIN_GROUP_MEMBERS+\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // ✅ VERIFICATION CHECK FOR GROUPS - ADMIN KO EXCLUDE KARO
                if (!$isPrivate && !$isAdmin && !$isVerified) {
                    $firstName = $userData['first_name'] ?? 'User';
                    $verificationMessage = "🔐 CHANNEL VERIFICATION REQUIRED\n";
                    $verificationMessage .= "═══════════════════════════════\n\n";
                    $verificationMessage .= "👋 Hello, " . htmlspecialchars($firstName) . "!\n\n";
                    $verificationMessage .= "⚠️ To use this command, you must join ALL THREE channels:\n\n";
                    
                    foreach ($REQUIRED_CHANNELS as $index => $channel) {
                        $channelNum = $index + 1;
                        $verificationMessage .= "📢 CHANNEL {$channelNum}\n";
                        $verificationMessage .= "   └─ {$channel['title']}\n";
                        $verificationMessage .= "   └─ {$channel['link']}\n\n";
                    }
                    
                    $verificationMessage .= "📋 Steps:\n";
                    $verificationMessage .= "1. Join ALL THREE channels above\n";
                    $verificationMessage .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
                    $verificationMessage .= "3. Start using the bot\n\n";
                    $verificationMessage .= "⚠️ Note: All three channels are compulsory\n\n";
                    $verificationMessage .= "👊 MADE BY SALAAR";
                    
                    $keyboard = [
                        [
                            ['text' => '✅ VERIFY MEMBERSHIP', 'callback_data' => 'verify_channels']
                        ]
                    ];
                    
                    sendMessageWithKeyboard($chatId, $verificationMessage, $keyboard);
                    break;
                }
                
                // Check user limit
                if ($userId && !isAdmin($userId)) {
                    if (!checkUserLimit($userId)) {
                        $stats = getUserSearchStats($userId);
                        sendMessage($chatId, 
                            "⚠️ DAILY LIMIT REACHED\n" .
                            "═══════════════════════\n\n" .
                            "📊 Today's Searches: {$stats['today_searches']}/5\n\n" .
                            "💳 UPGRADE TO PREMIUM\n" .
                            "──────────────────────\n" .
                            "Want more searches?\n\n" .
                            "Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "🔑 Get unlimited searches with premium!\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                        break;
                    }
                }
                
                $parts = explode(' ', $text, 2);
                if (count($parts) < 2) {
                    sendMessage($chatId, 
                        "❌ INVALID FORMAT\n" .
                        "══════════════════\n\n" .
                        "📋 Usage:\n" .
                        "`/vehicle RC123567890`\n\n" .
                        "🚗 Example:\n" .
                        "`/vehicle UP53AB1230`\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                $rcNumber = trim($parts[1]);
                
                // Send loading message
                $loadingMsg = sendLoadingMessage($chatId, "Vehicle RC", $rcNumber);
                $loadingMsgId = $loadingMsg['result']['message_id'] ?? null;
                
                sendTyping($chatId);
                
                // Call vehicle API only
                $vehicleData = getVehicleInfo($rcNumber);
                
                // Format with new structure
                $formattedData = [
                    'success' => true,
                    'data' => $vehicleData,
                    'source' => '/vehicle'
                ];
                
                // Update user limit if search was successful
                if ($userId && !isAdmin($userId)) {
                    if (is_array($vehicleData) && !isset($vehicleData['error']) && !isset($vehicleData['status'])) {
                        updateUserLimitForSuccess($userId);
                    }
                }
                
                if ($loadingMsgId) {
                    // Use smart edit function which decides file or message
                    smartEditMessage($chatId, $loadingMsgId, $rcNumber, $formattedData, $userData, $userId);
                } else {
                    $resultText = displayJsonOutput($rcNumber, $formattedData, $userData, $userId);
                    // Use smart send function which decides file or message
                    smartSendMessage($chatId, $resultText, $rcNumber, $userData, $userId);
                }
                break;
                
            case '/aadhar':
            case '/aadharinfo':
                // Check if user is in private chat (not allowed for non-admins)
                if ($isPrivate && !$isAdmin) {
                    sendMessage($chatId, 
                        "🚫 BOT USAGE POLICY\n" .
                        "══════════════════════\n\n" .
                        "This bot works only in groups!\n\n" .
                        "🤖 Please use this bot in group chats.\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 To add this bot to your group:\n" .
                        $BOT_INVITE_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                if (!$isPrivate && !$isAdmin && !isGroupAllowed($chatId)) {
                    $memberCount = getGroupMemberCount($chatId);
                    sendMessage($chatId,
                        "🚫 GROUP REQUIREMENTS NOT MET\n" .
                        "═════════════════════════════\n\n" .
                        "👥 Current Members: $memberCount\n" .
                        "📊 Required Members: $MIN_GROUP_MEMBERS+\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // ✅ VERIFICATION CHECK FOR GROUPS - ADMIN KO EXCLUDE KARO
                if (!$isPrivate && !$isAdmin && !$isVerified) {
                    $firstName = $userData['first_name'] ?? 'User';
                    $verificationMessage = "🔐 CHANNEL VERIFICATION REQUIRED\n";
                    $verificationMessage .= "═══════════════════════════════\n\n";
                    $verificationMessage .= "👋 Hello, " . htmlspecialchars($firstName) . "!\n\n";
                    $verificationMessage .= "⚠️ To use this command, you must join ALL THREE channels:\n\n";
                    
                    foreach ($REQUIRED_CHANNELS as $index => $channel) {
                        $channelNum = $index + 1;
                        $verificationMessage .= "📢 CHANNEL {$channelNum}\n";
                        $verificationMessage .= "   └─ {$channel['title']}\n";
                        $verificationMessage .= "   └─ {$channel['link']}\n\n";
                    }
                    
                    $verificationMessage .= "📋 Steps:\n";
                    $verificationMessage .= "1. Join ALL THREE channels above\n";
                    $verificationMessage .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
                    $verificationMessage .= "3. Start using the bot\n\n";
                    $verificationMessage .= "⚠️ Note: All three channels are compulsory\n\n";
                    $verificationMessage .= "👊 MADE BY SALAAR";
                    
                    $keyboard = [
                        [
                            ['text' => '✅ VERIFY MEMBERSHIP', 'callback_data' => 'verify_channels']
                        ]
                    ];
                    
                    sendMessageWithKeyboard($chatId, $verificationMessage, $keyboard);
                    break;
                }
                
                // Check user limit
                if ($userId && !isAdmin($userId)) {
                    if (!checkUserLimit($userId)) {
                        $stats = getUserSearchStats($userId);
                        sendMessage($chatId, 
                            "⚠️ DAILY LIMIT REACHED\n" .
                            "═══════════════════════\n\n" .
                            "📊 Today's Searches: {$stats['today_searches']}/5\n\n" .
                            "💳 UPGRADE TO PREMIUM\n" .
                            "──────────────────────\n" .
                            "Want more searches?\n\n" .
                            "Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "🔑 Get unlimited searches with premium!\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                        break;
                    }
                }
                
                $parts = explode(' ', $text, 2);
                if (count($parts) < 2) {
                    sendMessage($chatId, 
                        "❌ INVALID FORMAT\n" .
                        "══════════════════\n\n" .
                        "📋 Usage:\n" .
                        "`/aadhar 123156789012`\n\n" .
                        "🆔 Example:\n" .
                        "`/aadhar 123156789012`\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                $aadharNumber = trim($parts[1]);
                
                // Validate Aadhar number (basic check)
                if (!preg_match('/^[0-9]{12}$/', $aadharNumber)) {
                    sendMessage($chatId, 
                        "❌ INVALID AADHAR NUMBER\n" .
                        "════════════════════════\n\n" .
                        "Please provide a valid 12-digit Aadhar number.\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // Send loading message
                $loadingMsg = sendLoadingMessage($chatId, "Aadhar Number", $aadharNumber);
                $loadingMsgId = $loadingMsg['result']['message_id'] ?? null;
                
                sendTyping($chatId);
                
                // ========== FIXED HERE: NOW USING getAadharInfo() INSTEAD OF getAadharFamilyInfo() ==========
                $aadharData = getAadharInfo($aadharNumber); // NEW FUNCTION FOR NORMAL AADHAR
                
                // Format with new structure
                $formattedData = [
                    'success' => true,
                    'data' => $aadharData,
                    'source' => '/aadhar'
                ];
                
                // Update user limit if search was successful
                if ($userId && !isAdmin($userId)) {
                    if (is_array($aadharData) && !isset($aadharData['error']) && !isset($aadharData['status'])) {
                        updateUserLimitForSuccess($userId);
                    }
                }
                
                if ($loadingMsgId) {
                    // Use smart edit function which decides file or message
                    smartEditMessage($chatId, $loadingMsgId, $aadharNumber, $formattedData, $userData, $userId);
                } else {
                    $resultText = displayJsonOutput($aadharNumber, $formattedData, $userData, $userId);
                    // Use smart send function which decides file or message
                    smartSendMessage($chatId, $resultText, $aadharNumber, $userData, $userId);
                }
                break;
                
            case '/aadharfamily':
                // Check if user is in private chat (not allowed for non-admins)
                if ($isPrivate && !$isAdmin) {
                    sendMessage($chatId, 
                        "🚫 BOT USAGE POLICY\n" .
                        "══════════════════════\n\n" .
                        "This bot works only in groups!\n\n" .
                        "🤖 Please use this bot in group chats.\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 To add this bot to your group:\n" .
                        $BOT_INVITE_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                if (!$isPrivate && !$isAdmin && !isGroupAllowed($chatId)) {
                    $memberCount = getGroupMemberCount($chatId);
                    sendMessage($chatId,
                        "🚫 GROUP REQUIREMENTS NOT MET\n" .
                        "═════════════════════════════\n\n" .
                        "👥 Current Members: $memberCount\n" .
                        "📊 Required Members: $MIN_GROUP_MEMBERS+\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // ✅ VERIFICATION CHECK FOR GROUPS - ADMIN KO EXCLUDE KARO
                if (!$isPrivate && !$isAdmin && !$isVerified) {
                    $firstName = $userData['first_name'] ?? 'User';
                    $verificationMessage = "🔐 CHANNEL VERIFICATION REQUIRED\n";
                    $verificationMessage .= "═══════════════════════════════\n\n";
                    $verificationMessage .= "👋 Hello, " . htmlspecialchars($firstName) . "!\n\n";
                    $verificationMessage .= "⚠️ To use this command, you must join ALL THREE channels:\n\n";
                    
                    foreach ($REQUIRED_CHANNELS as $index => $channel) {
                        $channelNum = $index + 1;
                        $verificationMessage .= "📢 CHANNEL {$channelNum}\n";
                        $verificationMessage .= "   └─ {$channel['title']}\n";
                        $verificationMessage .= "   └─ {$channel['link']}\n\n";
                    }
                    
                    $verificationMessage .= "📋 Steps:\n";
                    $verificationMessage .= "1. Join ALL THREE channels above\n";
                    $verificationMessage .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
                    $verificationMessage .= "3. Start using the bot\n\n";
                    $verificationMessage .= "⚠️ Note: All three channels are compulsory\n\n";
                    $verificationMessage .= "👊 MADE BY SALAAR";
                    
                    $keyboard = [
                        [
                            ['text' => '✅ VERIFY MEMBERSHIP', 'callback_data' => 'verify_channels']
                        ]
                    ];
                    
                    sendMessageWithKeyboard($chatId, $verificationMessage, $keyboard);
                    break;
                }
                
                // Check user limit
                if ($userId && !isAdmin($userId)) {
                    if (!checkUserLimit($userId)) {
                        $stats = getUserSearchStats($userId);
                        sendMessage($chatId, 
                            "⚠️ DAILY LIMIT REACHED\n" .
                            "═══════════════════════\n\n" .
                            "📊 Today's Searches: {$stats['today_searches']}/5\n\n" .
                            "💳 UPGRADE TO PREMIUM\n" .
                            "──────────────────────\n" .
                            "Want more searches?\n\n" .
                            "Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "🔑 Get unlimited searches with premium!\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                        break;
                    }
                }
                
                $parts = explode(' ', $text, 2);
                if (count($parts) < 2) {
                    sendMessage($chatId, 
                        "❌ INVALID FORMAT\n" .
                        "══════════════════\n\n" .
                        "📋 Usage:\n" .
                        "`/aadharfamily 123456789012`\n\n" .
                        "👨‍👩‍👧‍👦 Example:\n" .
                        "`/aadharfamily 123456789012`\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                $aadharNumber = trim($parts[1]);
                
                // Validate Aadhar number (basic check)
                if (!preg_match('/^[0-9]{12}$/', $aadharNumber)) {
                    sendMessage($chatId, 
                        "❌ INVALID AADHAR NUMBER\n" .
                        "════════════════════════\n\n" .
                        "Please provide a valid 12-digit Aadhar number.\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // Send loading message
                $loadingMsg = sendLoadingMessage($chatId, "Aadhar Family", $aadharNumber);
                $loadingMsgId = $loadingMsg['result']['message_id'] ?? null;
                
                sendTyping($chatId);
                
                $aadharData = getAadharFamilyInfo($aadharNumber);
                
                // Update user limit if search was successful
                if ($userId && !isAdmin($userId)) {
                    if (is_array($aadharData) && !isset($aadharData['error']) && !isset($aadharData['status'])) {
                        updateUserLimitForSuccess($userId);
                    }
                }
                
                if ($loadingMsgId) {
                    // Use smart edit function which decides file or message
                    smartEditMessage($chatId, $loadingMsgId, $aadharNumber, $aadharData, $userData, $userId);
                } else {
                    $resultText = displayJsonOutput($aadharNumber, $aadharData, $userData, $userId);
                    // Use smart send function which decides file or message
                    smartSendMessage($chatId, $resultText, $aadharNumber, $userData, $userId);
                }
                break;
                
            case '/fampay':
                // Check if user is in private chat (not allowed for non-admins)
                if ($isPrivate && !$isAdmin) {
                    sendMessage($chatId, 
                        "🚫 BOT USAGE POLICY\n" .
                        "══════════════════════\n\n" .
                        "This bot works only in groups!\n\n" .
                        "🤖 Please use this bot in group chats.\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 To add this bot to your group:\n" .
                        $BOT_INVITE_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                if (!$isPrivate && !$isAdmin && !isGroupAllowed($chatId)) {
                    $memberCount = getGroupMemberCount($chatId);
                    sendMessage($chatId,
                        "🚫 GROUP REQUIREMENTS NOT MET\n" .
                        "═════════════════════════════\n\n" .
                        "👥 Current Members: $memberCount\n" .
                        "📊 Required Members: $MIN_GROUP_MEMBERS+\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // ✅ VERIFICATION CHECK FOR GROUPS - ADMIN KO EXCLUDE KARO
                if (!$isPrivate && !$isAdmin && !$isVerified) {
                    $firstName = $userData['first_name'] ?? 'User';
                    $verificationMessage = "🔐 CHANNEL VERIFICATION REQUIRED\n";
                    $verificationMessage .= "═══════════════════════════════\n\n";
                    $verificationMessage .= "👋 Hello, " . htmlspecialchars($firstName) . "!\n\n";
                    $verificationMessage .= "⚠️ To use this command, you must join ALL THREE channels:\n\n";
                    
                    foreach ($REQUIRED_CHANNELS as $index => $channel) {
                        $channelNum = $index + 1;
                        $verificationMessage .= "📢 CHANNEL {$channelNum}\n";
                        $verificationMessage .= "   └─ {$channel['title']}\n";
                        $verificationMessage .= "   └─ {$channel['link']}\n\n";
                    }
                    
                    $verificationMessage .= "📋 Steps:\n";
                    $verificationMessage .= "1. Join ALL THREE channels above\n";
                    $verificationMessage .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
                    $verificationMessage .= "3. Start using the bot\n\n";
                    $verificationMessage .= "⚠️ Note: All three channels are compulsory\n\n";
                    $verificationMessage .= "👊 MADE BY SALAAR";
                    
                    $keyboard = [
                        [
                            ['text' => '✅ VERIFY MEMBERSHIP', 'callback_data' => 'verify_channels']
                        ]
                    ];
                    
                    sendMessageWithKeyboard($chatId, $verificationMessage, $keyboard);
                    break;
                }
                
                // Check fampay cooldown
                if (!canSearchFampay($userId)) {
                    $remainingTime = getFampayCooldown($userId);
                    $minutes = floor($remainingTime / 60);
                    $seconds = $remainingTime % 60;
                    
                    sendMessage($chatId, 
                        "⏳ FAMPAY SEARCH COOLDOWN\n" .
                        "═════════════════════════\n\n" .
                        "You can search fampay again in: {$minutes}m {$seconds}s\n\n" .
                        "⚠️ Note: Fampay searches have a 10-minute cooldown to prevent abuse.\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // Check user limit
                if ($userId && !isAdmin($userId)) {
                    if (!checkUserLimit($userId)) {
                        $stats = getUserSearchStats($userId);
                        sendMessage($chatId, 
                            "⚠️ DAILY LIMIT REACHED\n" .
                            "═══════════════════════\n\n" .
                            "📊 Today's Searches: {$stats['today_searches']}/5\n\n" .
                            "💳 UPGRADE TO PREMIUM\n" .
                            "──────────────────────\n" .
                            "Want more searches?\n\n" .
                            "Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "🔑 Get unlimited searches and bypass fampay cooldown!\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                        break;
                    }
                }
                
                $parts = explode(' ', $text, 2);
                if (count($parts) < 2) {
                    sendMessage($chatId, 
                        "❌ INVALID FORMAT\n" .
                        "══════════════════\n\n" .
                        "📋 Usage:\n" .
                        "`/fampay maintenance mode` or `/fampay vishnu32011`\n\n" .
                        "💳 Examples:\n" .
                        "`/fampay vishnu32011@fam`\n" .
                        "`/fampay vishnu32011`\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                $fampayQuery = trim($parts[1]);
                
                // Send loading message
                $loadingMsg = sendLoadingMessage($chatId, "Fampay", $fampayQuery);
                $loadingMsgId = $loadingMsg['result']['message_id'] ?? null;
                
                sendTyping($chatId);
                
                $fampayData = getFampayInfo($fampayQuery);
                
                // Update fampay timer if search was successful
                if ($userId && !isAdmin($userId)) {
                    if (is_array($fampayData) && !isset($fampayData['error']) && !isset($fampayData['status'])) {
                        updateFampayTimer($userId);
                        updateUserLimitForSuccess($userId);
                    }
                }
                
                if ($loadingMsgId) {
                    // Use smart edit function which decides file or message
                    smartEditMessage($chatId, $loadingMsgId, $fampayQuery, $fampayData, $userData, $userId);
                } else {
                    $resultText = displayJsonOutput($fampayQuery, $fampayData, $userData, $userId);
                    // Use smart send function which decides file or message
                    smartSendMessage($chatId, $resultText, $fampayQuery, $userData, $userId);
                }
                break;
                
            case '/instagram':
                // Check if user is in private chat (not allowed for non-admins)
                if ($isPrivate && !$isAdmin) {
                    sendMessage($chatId, 
                        "🚫 BOT USAGE POLICY\n" .
                        "══════════════════════\n\n" .
                        "This bot works only in groups!\n\n" .
                        "🤖 Please use this bot in group chats.\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 To add this bot to your group:\n" .
                        $BOT_INVITE_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                if (!$isPrivate && !$isAdmin && !isGroupAllowed($chatId)) {
                    $memberCount = getGroupMemberCount($chatId);
                    sendMessage($chatId,
                        "🚫 GROUP REQUIREMENTS NOT MET\n" .
                        "═════════════════════════════\n\n" .
                        "👥 Current Members: $memberCount\n" .
                        "📊 Required Members: $MIN_GROUP_MEMBERS+\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // ✅ VERIFICATION CHECK FOR GROUPS - ADMIN KO EXCLUDE KARO
                if (!$isPrivate && !$isAdmin && !$isVerified) {
                    $firstName = $userData['first_name'] ?? 'User';
                    $verificationMessage = "🔐 CHANNEL VERIFICATION REQUIRED\n";
                    $verificationMessage .= "═══════════════════════════════\n\n";
                    $verificationMessage .= "👋 Hello, " . htmlspecialchars($firstName) . "!\n\n";
                    $verificationMessage .= "⚠️ To use this command, you must join ALL THREE channels:\n\n";
                    
                    foreach ($REQUIRED_CHANNELS as $index => $channel) {
                        $channelNum = $index + 1;
                        $verificationMessage .= "📢 CHANNEL {$channelNum}\n";
                        $verificationMessage .= "   └─ {$channel['title']}\n";
                        $verificationMessage .= "   └─ {$channel['link']}\n\n";
                    }
                    
                    $verificationMessage .= "📋 Steps:\n";
                    $verificationMessage .= "1. Join ALL THREE channels above\n";
                    $verificationMessage .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
                    $verificationMessage .= "3. Start using the bot\n\n";
                    $verificationMessage .= "⚠️ Note: All three channels are compulsory\n\n";
                    $verificationMessage .= "👊 MADE BY SALAAR";
                    
                    $keyboard = [
                        [
                            ['text' => '✅ VERIFY MEMBERSHIP', 'callback_data' => 'verify_channels']
                        ]
                    ];
                    
                    sendMessageWithKeyboard($chatId, $verificationMessage, $keyboard);
                    break;
                }
                
                // Check user limit
                if ($userId && !isAdmin($userId)) {
                    if (!checkUserLimit($userId)) {
                        $stats = getUserSearchStats($userId);
                        sendMessage($chatId, 
                            "⚠️ DAILY LIMIT REACHED\n" .
                            "═══════════════════════\n\n" .
                            "📊 Today's Searches: {$stats['today_searches']}/5\n\n" .
                            "💳 UPGRADE TO PREMIUM\n" .
                            "──────────────────────\n" .
                            "Want more searches?\n\n" .
                            "Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "🔑 Get unlimited searches with premium!\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                        break;
                    }
                }
                
                $parts = explode(' ', $text, 2);
                if (count($parts) < 2) {
                    sendMessage($chatId, 
                        "❌ INVALID FORMAT\n" .
                        "══════════════════\n\n" .
                        "📋 Usage:\n" .
                        "`/instagram username`\n\n" .
                        "📷 Example:\n" .
                        "`/instagram instagram`\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                $username = trim($parts[1]);
                
                // Send loading message
                $loadingMsg = sendLoadingMessage($chatId, "Instagram", $username);
                $loadingMsgId = $loadingMsg['result']['message_id'] ?? null;
                
                sendTyping($chatId);
                
                $instagramData = getInstagramInfo($username);
                
                // Format with new structure
                $formattedData = [
                    'success' => true,
                    'data' => $instagramData,
                    'source' => '/instagram'
                ];
                
                // Update user limit if search was successful
                if ($userId && !isAdmin($userId)) {
                    if (is_array($instagramData) && !isset($instagramData['error']) && !isset($instagramData['status'])) {
                        updateUserLimitForSuccess($userId);
                    }
                }
                
                if ($loadingMsgId) {
                    // Use smart edit function which decides file or message
                    smartEditMessage($chatId, $loadingMsgId, $username, $formattedData, $userData, $userId);
                } else {
                    $resultText = displayJsonOutput($username, $formattedData, $userData, $userId);
                    // Use smart send function which decides file or message
                    smartSendMessage($chatId, $resultText, $username, $userData, $userId);
                }
                break;
                
            case '/ip':
                // Check if user is in private chat (not allowed for non-admins)
                if ($isPrivate && !$isAdmin) {
                    sendMessage($chatId, 
                        "🚫 BOT USAGE POLICY\n" .
                        "══════════════════════\n\n" .
                        "This bot works only in groups!\n\n" .
                        "🤖 Please use this bot in group chats.\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 To add this bot to your group:\n" .
                        $BOT_INVITE_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                if (!$isPrivate && !$isAdmin && !isGroupAllowed($chatId)) {
                    $memberCount = getGroupMemberCount($chatId);
                    sendMessage($chatId,
                        "🚫 GROUP REQUIREMENTS NOT MET\n" .
                        "═════════════════════════════\n\n" .
                        "👥 Current Members: $memberCount\n" .
                        "📊 Required Members: $MIN_GROUP_MEMBERS+\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // ✅ VERIFICATION CHECK FOR GROUPS - ADMIN KO EXCLUDE KARO
                if (!$isPrivate && !$isAdmin && !$isVerified) {
                    $firstName = $userData['first_name'] ?? 'User';
                    $verificationMessage = "🔐 CHANNEL VERIFICATION REQUIRED\n";
                    $verificationMessage .= "═══════════════════════════════\n\n";
                    $verificationMessage .= "👋 Hello, " . htmlspecialchars($firstName) . "!\n\n";
                    $verificationMessage .= "⚠️ To use this command, you must join ALL THREE channels:\n\n";
                    
                    foreach ($REQUIRED_CHANNELS as $index => $channel) {
                        $channelNum = $index + 1;
                        $verificationMessage .= "📢 CHANNEL {$channelNum}\n";
                        $verificationMessage .= "   └─ {$channel['title']}\n";
                        $verificationMessage .= "   └─ {$channel['link']}\n\n";
                    }
                    
                    $verificationMessage .= "📋 Steps:\n";
                    $verificationMessage .= "1. Join ALL THREE channels above\n";
                    $verificationMessage .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
                    $verificationMessage .= "3. Start using the bot\n\n";
                    $verificationMessage .= "⚠️ Note: All three channels are compulsory\n\n";
                    $verificationMessage .= "👊 MADE BY SALAAR";
                    
                    $keyboard = [
                        [
                            ['text' => '✅ VERIFY MEMBERSHIP', 'callback_data' => 'verify_channels']
                        ]
                    ];
                    
                    sendMessageWithKeyboard($chatId, $verificationMessage, $keyboard);
                    break;
                }
                
                // Check user limit
                if ($userId && !isAdmin($userId)) {
                    if (!checkUserLimit($userId)) {
                        $stats = getUserSearchStats($userId);
                        sendMessage($chatId, 
                            "⚠️ DAILY LIMIT REACHED\n" .
                            "═══════════════════════\n\n" .
                            "📊 Today's Searches: {$stats['today_searches']}/5\n\n" .
                            "💳 UPGRADE TO PREMIUM\n" .
                            "──────────────────────\n" .
                            "Want more searches?\n\n" .
                            "Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "🔑 Get unlimited searches with premium!\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                        break;
                    }
                }
                
                $parts = explode(' ', $text, 2);
                if (count($parts) < 2) {
                    sendMessage($chatId, 
                        "❌ INVALID FORMAT\n" .
                        "══════════════════\n\n" .
                        "📋 Usage:\n" .
                        "`/ip 8.8.8.8`\n\n" .
                        "🌐 Example:\n" .
                        "`/ip 8.8.8.8`\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                $ip = trim($parts[1]);
                
                // Basic IP validation
                if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                    sendMessage($chatId, 
                        "❌ INVALID IP ADDRESS\n" .
                        "══════════════════════\n\n" .
                        "Please provide a valid IP address.\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // Send loading message
                $loadingMsg = sendLoadingMessage($chatId, "IP Address", $ip);
                $loadingMsgId = $loadingMsg['result']['message_id'] ?? null;
                
                sendTyping($chatId);
                
                $ipData = getIpInfo($ip);
                
                // Format with new structure
                $formattedData = [
                    'success' => true,
                    'data' => $ipData,
                    'source' => '/ip'
                ];
                
                // Update user limit if search was successful
                if ($userId && !isAdmin($userId)) {
                    if (is_array($ipData) && !isset($ipData['error']) && !isset($ipData['status'])) {
                        updateUserLimitForSuccess($userId);
                    }
                }
                
                if ($loadingMsgId) {
                    // Use smart edit function which decides file or message
                    smartEditMessage($chatId, $loadingMsgId, $ip, $formattedData, $userData, $userId);
                } else {
                    $resultText = displayJsonOutput($ip, $formattedData, $userData, $userId);
                    // Use smart send function which decides file or message
                    smartSendMessage($chatId, $resultText, $ip, $userData, $userId);
                }
                break;
                
            case '/pakistan':
                // Check if user is in private chat (not allowed for non-admins)
                if ($isPrivate && !$isAdmin) {
                    sendMessage($chatId, 
                        "🚫 BOT USAGE POLICY\n" .
                        "══════════════════════\n\n" .
                        "This bot works only in groups!\n\n" .
                        "🤖 Please use this bot in group chats.\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 To add this bot to your group:\n" .
                        $BOT_INVITE_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                if (!$isPrivate && !$isAdmin && !isGroupAllowed($chatId)) {
                    $memberCount = getGroupMemberCount($chatId);
                    sendMessage($chatId,
                        "🚫 GROUP REQUIREMENTS NOT MET\n" .
                        "═════════════════════════════\n\n" .
                        "👥 Current Members: $memberCount\n" .
                        "📊 Required Members: $MIN_GROUP_MEMBERS+\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // ✅ VERIFICATION CHECK FOR GROUPS - ADMIN KO EXCLUDE KARO
                if (!$isPrivate && !$isAdmin && !$isVerified) {
                    $firstName = $userData['first_name'] ?? 'User';
                    $verificationMessage = "🔐 CHANNEL VERIFICATION REQUIRED\n";
                    $verificationMessage .= "═══════════════════════════════\n\n";
                    $verificationMessage .= "👋 Hello, " . htmlspecialchars($firstName) . "!\n\n";
                    $verificationMessage .= "⚠️ To use this command, you must join ALL THREE channels:\n\n";
                    
                    foreach ($REQUIRED_CHANNELS as $index => $channel) {
                        $channelNum = $index + 1;
                        $verificationMessage .= "📢 CHANNEL {$channelNum}\n";
                        $verificationMessage .= "   └─ {$channel['title']}\n";
                        $verificationMessage .= "   └─ {$channel['link']}\n\n";
                    }
                    
                    $verificationMessage .= "📋 Steps:\n";
                    $verificationMessage .= "1. Join ALL THREE channels above\n";
                    $verificationMessage .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
                    $verificationMessage .= "3. Start using the bot\n\n";
                    $verificationMessage .= "⚠️ Note: All three channels are compulsory\n\n";
                    $verificationMessage .= "👊 MADE BY SALAAR";
                    
                    $keyboard = [
                        [
                            ['text' => '✅ VERIFY MEMBERSHIP', 'callback_data' => 'verify_channels']
                        ]
                    ];
                    
                    sendMessageWithKeyboard($chatId, $verificationMessage, $keyboard);
                    break;
                }
                
                // Check user limit
                if ($userId && !isAdmin($userId)) {
                    if (!checkUserLimit($userId)) {
                        $stats = getUserSearchStats($userId);
                        sendMessage($chatId, 
                            "⚠️ DAILY LIMIT REACHED\n" .
                            "═══════════════════════\n\n" .
                            "📊 Today's Searches: {$stats['today_searches']}/5\n\n" .
                            "💳 UPGRADE TO PREMIUM\n" .
                            "──────────────────────\n" .
                            "Want more searches?\n\n" .
                            "Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "🔑 Get unlimited searches with premium!\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                        break;
                    }
                }
                
                $parts = explode(' ', $text, 2);
                if (count($parts) < 2) {
                    sendMessage($chatId, 
                        "❌ INVALID FORMAT\n" .
                        "══════════════════\n\n" .
                        "📋 Usage:\n" .
                        "`/pakistan 923078636966`\n\n" .
                        "🇵🇰 Example:\n" .
                        "`/pakistan 923078636966`\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                $phone = trim($parts[1]);
                
                // Validate Pakistan phone number (starts with 92)
                if (!preg_match('/^92[0-9]{9,10}$/', $phone)) {
                    sendMessage($chatId, 
                        "❌ INVALID PAKISTAN NUMBER\n" .
                        "══════════════════════════\n\n" .
                        "Please provide a valid Pakistan phone number starting with 92.\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // Send loading message
                $loadingMsg = sendLoadingMessage($chatId, "Pakistan Number", $phone);
                $loadingMsgId = $loadingMsg['result']['message_id'] ?? null;
                
                sendTyping($chatId);
                
                $pakistanData = getPakistanNumberInfo($phone);
                
                // Format with new structure
                $formattedData = [
                    'success' => true,
                    'data' => $pakistanData,
                    'source' => '/pakistan'
                ];
                
                // Update user limit if search was successful
                if ($userId && !isAdmin($userId)) {
                    if (is_array($pakistanData) && !isset($pakistanData['error']) && !isset($pakistanData['status'])) {
                        updateUserLimitForSuccess($userId);
                    }
                }
                
                if ($loadingMsgId) {
                    // Use smart edit function which decides file or message
                    smartEditMessage($chatId, $loadingMsgId, $phone, $formattedData, $userData, $userId);
                } else {
                    $resultText = displayJsonOutput($phone, $formattedData, $userData, $userId);
                    // Use smart send function which decides file or message
                    smartSendMessage($chatId, $resultText, $phone, $userData, $userId);
                }
                break;
                
            case '/telegram':
                // Check if user is in private chat (not allowed for non-admins)
                if ($isPrivate && !$isAdmin) {
                    sendMessage($chatId, 
                        "🚫 BOT USAGE POLICY\n" .
                        "══════════════════════\n\n" .
                        "This bot works only in groups!\n\n" .
                        "🤖 Please use this bot in group chats.\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 To add this bot to your group:\n" .
                        $BOT_INVITE_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                if (!$isPrivate && !$isAdmin && !isGroupAllowed($chatId)) {
                    $memberCount = getGroupMemberCount($chatId);
                    sendMessage($chatId,
                        "🚫 GROUP REQUIREMENTS NOT MET\n" .
                        "═════════════════════════════\n\n" .
                        "👥 Current Members: $memberCount\n" .
                        "📊 Required Members: $MIN_GROUP_MEMBERS+\n\n" .
                        "📢 Join our working group:\n" .
                        $GROUP_LINK . "\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // ✅ VERIFICATION CHECK FOR GROUPS - ADMIN KO EXCLUDE KARO
                if (!$isPrivate && !$isAdmin && !$isVerified) {
                    $firstName = $userData['first_name'] ?? 'User';
                    $verificationMessage = "🔐 CHANNEL VERIFICATION REQUIRED\n";
                    $verificationMessage .= "═══════════════════════════════\n\n";
                    $verificationMessage .= "👋 Hello, " . htmlspecialchars($firstName) . "!\n\n";
                    $verificationMessage .= "⚠️ To use this command, you must join ALL THREE channels:\n\n";
                    
                    foreach ($REQUIRED_CHANNELS as $index => $channel) {
                        $channelNum = $index + 1;
                        $verificationMessage .= "📢 CHANNEL {$channelNum}\n";
                        $verificationMessage .= "   └─ {$channel['title']}\n";
                        $verificationMessage .= "   └─ {$channel['link']}\n\n";
                    }
                    
                    $verificationMessage .= "📋 Steps:\n";
                    $verificationMessage .= "1. Join ALL THREE channels above\n";
                    $verificationMessage .= "2. Click '✅ VERIFY MEMBERSHIP' below\n";
                    $verificationMessage .= "3. Start using the bot\n\n";
                    $verificationMessage .= "⚠️ Note: All three channels are compulsory\n\n";
                    $verificationMessage .= "👊 MADE BY SALAAR";
                    
                    $keyboard = [
                        [
                            ['text' => '✅ VERIFY MEMBERSHIP', 'callback_data' => 'verify_channels']
                        ]
                    ];
                    
                    sendMessageWithKeyboard($chatId, $verificationMessage, $keyboard);
                    break;
                }
                
                // Check user limit
                if ($userId && !isAdmin($userId)) {
                    if (!checkUserLimit($userId)) {
                        $stats = getUserSearchStats($userId);
                        sendMessage($chatId, 
                            "⚠️ DAILY LIMIT REACHED\n" .
                            "═══════════════════════\n\n" .
                            "📊 Today's Searches: {$stats['today_searches']}/5\n\n" .
                            "💳 UPGRADE TO PREMIUM\n" .
                            "──────────────────────\n" .
                            "Want more searches?\n\n" .
                            "Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "🔑 Get unlimited searches with premium!\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                        break;
                    }
                }
                
                $parts = explode(' ', $text, 2);
                if (count($parts) < 2) {
                    sendMessage($chatId, 
                        "❌ INVALID FORMAT\n" .
                        "══════════════════\n\n" .
                        "📋 Usage:\n" .
                        "`/telegram 7774387035`\n\n" .
                        "📱 Example:\n" .
                        "`/telegram 7774387035`\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                $telegramId = trim($parts[1]);
                
                // Validate Telegram ID
                if (!preg_match('/^[0-9]{5,15}$/', $telegramId)) {
                    sendMessage($chatId, 
                        "❌ INVALID TELEGRAM ID\n" .
                        "═══════════════════════\n\n" .
                        "Please provide a valid Telegram ID (5-15 digits).\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                    break;
                }
                
                // Send loading message
                $loadingMsg = sendLoadingMessage($chatId, "Telegram ID", $telegramId);
                $loadingMsgId = $loadingMsg['result']['message_id'] ?? null;
                
                sendTyping($chatId);
                
                $telegramData = getTelegramIdInfo($telegramId);
                
                // Format with new structure
                $formattedData = [
                    'success' => true,
                    'data' => $telegramData,
                    'source' => '/telegram'
                ];
                
                // Update user limit if search was successful
                if ($userId && !isAdmin($userId)) {
                    if (is_array($telegramData) && !isset($telegramData['error']) && !isset($telegramData['status'])) {
                        updateUserLimitForSuccess($userId);
                    }
                }
                
                if ($loadingMsgId) {
                    // Use smart edit function which decides file or message
                    smartEditMessage($chatId, $loadingMsgId, $telegramId, $formattedData, $userData, $userId);
                } else {
                    $resultText = displayJsonOutput($telegramId, $formattedData, $userData, $userId);
                    // Use smart send function which decides file or message
                    smartSendMessage($chatId, $resultText, $telegramId, $userData, $userId);
                }
                break;
                
            case '/myaccount':
                // Private chat में भी allow है
                $accountInfo = getUserAccountInfo($userId, $userData);
                sendMessage($chatId, $accountInfo);
                break;
                
            case '/stats':
                // Private chat में भी allow है
                $isAdminUser = isAdmin($userId);
                $stats = getChatStats();
                
                if ($isAdminUser) {
                    // Admin gets detailed stats
                    $allUsersStats = getAllUsersStats();
                    $message = "📊 BOT STATISTICS (ADMIN)\n";
                    $message .= "═════════════════════════\n\n";
                    
                    $message .= "👥 CHAT STATISTICS\n";
                    $message .= "───────────────────\n";
                    $message .= "• Total Chats: " . $stats['total'] . "\n";
                    $message .= "• Private Users: " . $stats['users'] . "\n";
                    $message .= "• Groups: " . $stats['groups'] . "\n\n";
                    
                    $message .= "🔍 SEARCH STATISTICS\n";
                    $message .= "─────────────────────\n";
                    $message .= "• Searches Today: " . $allUsersStats['total_today'] . "\n";
                    $message .= "• Total Searches: " . $allUsersStats['total_all_time'] . "\n";
                    $message .= "• Successful Searches: " . $allUsersStats['successful_searches'] . "\n";
                    $message .= "• Unlimited Users: " . $allUsersStats['unlimited_users'] . "\n\n";
                    
                    $message .= "🆔 SYSTEM INFORMATION\n";
                    $message .= "─────────────────────\n";
                    $message .= "• Your ID: `" . $userId . "`\n";
                    $message .= "• Chat ID: `" . $chatId . "`\n";
                    $message .= "• Group: " . ($message['chat']['username'] ?? 'N/A') . "\n";
                    $message .= "• Bot Status: Active\n\n";
                } else {
                    // Regular users get basic stats
                    $message = "📊 BOT STATISTICS\n";
                    $message .= "═══════════════════\n\n";
                    
                    $message .= "👥 CHAT STATISTICS\n";
                    $message .= "───────────────────\n";
                    $message .= "• Total Chats: " . $stats['total'] . "\n";
                    $message .= "• Private Users: " . $stats['users'] . "\n";
                    $message .= "• Groups: " . $stats['groups'] . "\n\n";
                    
                    $message .= "🆔 YOUR INFORMATION\n";
                    $message .= "───────────────────\n";
                    $message .= "• Your ID: `" . $userId . "`\n";
                    $message .= "• Bot Status: Active\n\n";
                }
                
                $message .= "👊 MADE BY SALAAR";
                sendMessage($chatId, $message);
                break;
                
            case '/broadcast':
                if (!isAdmin($userId)) {
                    sendMessage($chatId, "❌ You are not authorized to use this command.\n\n👊 MADE BY SALAAR");
                    break;
                }
                
                setBroadcastMode($userId, 'text');
                sendMessage($chatId, 
                    '📢 BROADCAST MODE\n' .
                    '═══════════════════\n\n' .
                    'Send the message you want to broadcast to all users and groups:\n\n' .
                    'Type `🚫 Cancel Broadcast` to cancel.\n\n' .
                    '👊 MADE BY SALAAR'
                );
                break;
                
            case '/admin':
                if (!isAdmin($userId)) {
                    sendMessage($chatId, "❌ You are not authorized to use this command.\n\n👊 MADE BY SALAAR");
                    break;
                }
                
                $stats = getChatStats();
                $allUsersStats = getAllUsersStats();
                
                $adminMessage = "👑 ADMIN PANEL\n";
                $adminMessage .= "════════════════\n\n";
                
                $adminMessage .= "📊 SYSTEM STATISTICS\n";
                $adminMessage .= "─────────────────────\n";
                $adminMessage .= "• Total Chats: " . $stats['total'] . "\n";
                $adminMessage .= "• Private Users: " . $stats['users'] . "\n";
                $adminMessage .= "• Groups: " . $stats['groups'] . "\n";
                $adminMessage .= "• Searches Today: " . $allUsersStats['total_today'] . "\n";
                $adminMessage .= "• Total Searches: " . $allUsersStats['total_all_time'] . "\n";
                $adminMessage .= "• Unlimited Users: " . $allUsersStats['unlimited_users'] . "\n\n";
                
                $adminMessage .= "🛠️ ADMIN COMMANDS\n";
                $adminMessage .= "─────────────────\n";
                $adminMessage .= "• `/addsearches` - Add searches to user\n";
                $adminMessage .= "• `/resetlimit` - Reset user daily limit\n";
                $adminMessage .= "• `/userstats` - Check user statistics\n";
                $adminMessage .= "• `/allusers` - All users statistics\n";
                $adminMessage .= "• `/broadcast` - Send message to all\n";
                $adminMessage .= "• `/resetall` - Reset all users limits\n";
                $adminMessage .= "• `/addgroup` - Add group to allowed list\n";
                $adminMessage .= "• `/removeunlimited` - Remove unlimited from user\n\n";
                
                $adminMessage .= "🤖 BOT INFORMATION\n";
                $adminMessage .= "───────────────────\n";
                $adminMessage .= "• Group: " . $GROUP_LINK . "\n";
                $adminMessage .= "• Min Members: " . $MIN_GROUP_MEMBERS . "\n";
                $adminMessage .= "• Required Channels: " . count($REQUIRED_CHANNELS) . "\n\n";
                
                $adminMessage .= "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n";
                $adminMessage .= "👊 MADE BY SALAAR";
                
                sendMessage($chatId, $adminMessage);
                break;
                
            case '/addsearches':
                if (!isAdmin($userId)) {
                    sendMessage($chatId, "❌ You are not authorized to use this command.\n\n👊 MADE BY SALAAR");
                    break;
                }
                
                setAdminState($userId, ['action' => 'add_searches']);
                sendMessage($chatId, 
                    "➕ ADD SEARCHES TO USER\n" .
                    "════════════════════════\n\n" .
                    "Send user ID and number of searches in format:\n" .
                    "`USER_ID NUMBER`\n\n" .
                    "📝 EXAMPLES:\n" .
                    "`123156789 50` - Add 50 searches\n" .
                    "`123156789 0` - Give UNLIMITED searches\n" .
                    "`123156789 -1` - Give UNLIMITED searches\n\n" .
                    "Type `🚫 Cancel` to cancel.\n\n" .
                    "👊 MADE BY SALAAR"
                );
                break;
                
            case '/resetlimit':
                if (!isAdmin($userId)) {
                    sendMessage($chatId, "❌ You are not authorized to use this command.\n\n👊 MADE BY SALAAR");
                    break;
                }
                
                setAdminState($userId, ['action' => 'reset_user']);
                sendMessage($chatId, 
                    "🔄 RESET USER LIMIT\n" .
                    "════════════════════\n\n" .
                    "Send user ID to reset their daily limit:\n\n" .
                    "Type `🚫 Cancel` to cancel.\n\n" .
                    "👊 MADE BY SALAAR"
                );
                break;
                
            case '/userstats':
                if (!isAdmin($userId)) {
                    sendMessage($chatId, "❌ You are not authorized to use this command.\n\n👊 MADE BY SALAAR");
                    break;
                }
                
                setAdminState($userId, ['action' => 'check_user']);
                sendMessage($chatId, 
                    "🔍 CHECK USER STATISTICS\n" .
                    "═════════════════════════\n\n" .
                    "Send user ID to check their search limits:\n\n" .
                    "Type `🚫 Cancel` to cancel.\n\n" .
                    "👊 MADE BY SALAAR"
                );
                break;
                
            case '/allusers':
                if (!isAdmin($userId)) {
                    sendMessage($chatId, "❌ You are not authorized to use this command.\n\n👊 MADE BY SALAAR");
                    break;
                }
                
                $allStats = getAllUsersStats();
                $message = "📊 ALL USERS STATISTICS\n";
                $message .= "════════════════════════\n\n";
                
                $message .= "📈 OVERVIEW\n";
                $message .= "───────────\n";
                $message .= "• Total Users: " . count($allStats['users']) . "\n";
                $message .= "• Searches Today: {$allStats['total_today']}\n";
                $message .= "• Total Searches: {$allStats['total_all_time']}\n";
                $message .= "• Successful Searches: {$allStats['successful_searches']}\n";
                $message .= "• Unlimited Users: {$allStats['unlimited_users']}\n\n";
                
                // Show top 10 users
                usort($allStats['users'], function($a, $b) {
                    return $b['total_searches'] - $a['total_searches'];
                });
                
                $message .= "🏆 TOP USERS\n";
                $message .= "─────────────\n";
                $count = 0;
                foreach ($allStats['users'] as $user) {
                    if ($count >= 10) break;
                    $status = $user['unlimited'] ? "🎉" : "📊";
                    $message .= "$status `{$user['user_id']}`: {$user['total_searches']} searches ({$user['successful_searches']} successful)\n";
                    $count++;
                }
                
                $message .= "\n👊 MADE BY SALAAR";
                sendMessage($chatId, $message);
                break;
                
            case '/resetall':
                if (!isAdmin($userId)) {
                    sendMessage($chatId, "❌ You are not authorized to use this command.\n\n👊 MADE BY SALAAR");
                    break;
                }
                
                $resetCount = resetAllUsersLimits();
                sendMessage($chatId, 
                    "✅ ALL USERS RESET SUCCESSFULLY\n" .
                    "══════════════════════════════\n\n" .
                    "🔄 Reset daily limits for $resetCount users\n\n" .
                    "Note: Unlimited users were not reset.\n\n" .
                    "👊 MADE BY SALAAR"
                );
                break;
                
            case '/addgroup':
                if (!isAdmin($userId)) {
                    sendMessage($chatId, "❌ You are not authorized to use this command.\n\n👊 MADE BY SALAAR");
                    break;
                }
                
                setAdminState($userId, ['action' => 'add_group']);
                sendMessage($chatId, 
                    "👥 ADD GROUP TO ALLOWED LIST\n" .
                    "═════════════════════════════\n\n" .
                    "Send group ID to add it to the allowed list:\n\n" .
                    "Type `🚫 Cancel` to cancel.\n\n" .
                    "👊 MADE BY SALAAR"
                );
                break;
                
            case '/removeunlimited':
                if (!isAdmin($userId)) {
                    sendMessage($chatId, "❌ You are not authorized to use this command.\n\n👊 MADE BY SALAAR");
                    break;
                }
                
                setAdminState($userId, ['action' => 'remove_unlimited']);
                sendMessage($chatId, 
                    "🚫 REMOVE UNLIMITED SEARCHES\n" .
                    "═════════════════════════════\n\n" .
                    "Send user ID to remove their unlimited status and reset to normal limits:\n\n" .
                    "Type `🚫 Cancel` to cancel.\n\n" .
                    "👊 MADE BY SALAAR"
                );
                break;
                
            default:
                // Unknown command
                if ($isPrivate) {
                    if ($isAdmin) {
                        sendMessage($chatId, 
                            "❌ UNKNOWN COMMAND\n" .
                            "═══════════════════\n\n" .
                            "📋 AVAILABLE COMMANDS\n" .
                            "─────────────────────\n" .
                            "• `/num [number]` - Search phone number\n" .
                            "• `/vehicle [rc]` - Vehicle RC lookup\n" .
                            "• `/aadhar [id]` - Aadhar information\n" .
                            "• `/aadharfamily [id]` - Aadhar family info\n" .
                            "• `/fampay [upi/username]` - Fampay lookup\n" .
                            "• `/instagram [username]` - Instagram info\n" .
                            "• `/ip [ip]` - IP address lookup\n" .
                            "• `/pakistan [number]` - Pakistan number lookup\n" .
                            "• `/telegram [id]` - Telegram ID lookup\n" .
                            "• `/myaccount` - Your account info\n" .
                            "• `/stats` - Bot statistics\n\n" .
                            "🔧 ADMIN COMMANDS\n" .
                            "─────────────────\n" .
                            "• `/admin` - Admin panel\n" .
                            "• `/addsearches` - Add searches to user\n" .
                            "• `/resetlimit` - Reset user limit\n" .
                            "• `/userstats` - Check user stats\n" .
                            "• `/allusers` - All users statistics\n" .
                            "• `/broadcast` - Send broadcast message\n" .
                            "• `/resetall` - Reset all users limits\n" .
                            "• `/addgroup` - Add group to allowed list\n" .
                            "• `/removeunlimited` - Remove unlimited from user\n\n" .
                            "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                    } else {
                        sendMessage($chatId, 
                            "❌ UNKNOWN COMMAND\n" .
                            "═══════════════════\n\n" .
                            "This bot works only in groups!\n\n" .
                            "🤖 Please use this bot in group chats.\n\n" .
                            "📢 Join our working group:\n" .
                            $GROUP_LINK . "\n\n" .
                            "🔧 To add this bot to your group:\n" .
                            $BOT_INVITE_LINK . "\n\n" .
                            "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                            "👊 MADE BY SALAAR"
                        );
                    }
                } else {
                    sendMessage($chatId,
                        "❌ UNKNOWN COMMAND\n" .
                        "═══════════════════\n\n" .
                        "📋 AVAILABLE COMMANDS\n" .
                        "─────────────────────\n" .
                        "• `/num [number]` - Phone lookup\n" .
                        "• `/vehicle [rc]` - Vehicle info\n" .
                        "• `/aadhar [id]` - Aadhar lookup\n" .
                        "• `/aadharfamily [id]` - Aadhar family info\n" .
                        "• `/fampay [upi/username]` - Fampay lookup\n" .
                        "• `/instagram [username]` - Instagram info\n" .
                        "• `/ip [ip]` - IP lookup\n" .
                        "• `/telegram [id]` - Telegram ID lookup\n" .
                        "• `/pakistan [number]` - Pakistan number lookup\n" .
                        "• `/myaccount` - Your account info\n" .
                        "• `/stats` - Bot statistics\n\n" .
                        "🔍 EXAMPLES:\n" .
                        "`/num 9988776655`\n" .
                        "`/vehicle UP53AB1231`\n" .
                        "`/aadhar 123156789012`\n" .
                        "`/aadharfamily 123456789012`\n" .
                        "`/fampay maintenance mode`\n" .
                        "`/instagram username`\n" .
                        "`/telegram 7774387035`\n" .
                        "`/pakistan 923078636966`\n\n" .
                        "🔧 Need help? Contact: https://t.me/+1yvxEv4b1KkzZGE1\n\n" .
                        "👊 MADE BY SALAAR"
                    );
                }
                break;
        }
    }
    
}
?>